# Memphis Cognitive Engine Skill

**Decision-first AI memory for OpenClaw**

---

## 🎯 Co to jest?

To skill dla OpenClaw który integruje **Memphis Cognitive Engine** - decision-first AI memory system.

**Memphis = Agent + LLM + Memory Chain + DECIDE**

---

## 🚀 Szybki Start

### 1. Instalacja

```bash
clawhub install memphis-cognitive-engine
```

### 2. Pierwsza decyzja

```bash
/memphis decide "Używam TypeScript dla projektu" "TypeScript" -r "Type safety"
```

### 3. Pytanie

```bash
/memphis ask "Dlaczego wybrałem TypeScript?"
```

### 4. Reflection

```bash
/memphis reflect --weekly --save
```

---

## 📚 Dokumentacja

**PEŁNA DOKUMENTACJA:** [MEMORY.md](file:///home/memphis/.openclaw/workspace/MEMORY.md)

**Oficjalna wizja:** [VISION.md](file:///home/memphis/memphis/docs/VISION.md)

---

## 🎯 Core Features

### 1. 💭 Decision Memory
- Zapisuj decyzje (conscious)
- Agent wykrywa decyzje (inferred)
- Śledź lifecycle (active → revised → reinforced)

### 2. 🧠 Intelligence System
- 90.7% accuracy auto-categorization
- 366 regex patterns
- Time-based suggestions
- Learning from feedback

### 3. 🤖 Agent Runtime
- Background daemon
- Git collector
- Shell collector
- Event detection

### 4. 🔌 Multi-Agent Network
- Trade protocol
- DID-based identity
- Signed manifests

### 5. 💻 Memory → Code
- `/memphis plan --exec`
- Generuj coding task z pamięci
- Auto-execute z codex

---

## 📋 Główne Komendy

### Decyzje:
- `/memphis decide` - Zapisz decyzję
- `/memphis decisions` - Listuj decyzje
- `/memphis revise` - Zaktualizuj decyzję
- `/memphis reflect` - LLM reflection

### Pamięć:
- `/memphis journal` - Zapisz event
- `/memphis ask` - Zapytaj z kontekstem
- `/memphis recall` - Semantic search

### Advanced:
- `/memphis plan --exec` - Memory → Code
- `/memphis intelligence` - Learning stats
- `/memphis daemon` - Background agent
- `/memphis graph` - Knowledge graph

---

## 🏗️ Architektura

```
┌─────────────────────────────────────────┐
│  OpenClaw + Memphis Skill               │
├─────────────────────────────────────────┤
│  Memphis CLI (35+ commands)             │
├─────────────────────────────────────────┤
│  Agent + LLM + Memory Chain             │
└─────────────────────────────────────────┘
```

---

## 💡 Use Cases

### Dla Developer-Business Ownera:
- ✅ CRM inteligentny
- ✅ Zarządzanie projektami
- ✅ Finanse tracking
- ✅ Spotkania notes

### Dla Developera:
- ✅ Technical decisions log
- ✅ Architecture choices
- ✅ Bug fixes history
- ✅ Code rationale

### Dla Przedsiębiorcy:
- ✅ Business decisions
- ✅ Client interactions
- ✅ Investment tracking
- ✅ Strategy evolution

---

## 🇵🇱 Polish Support

Memphis wspiera polskie keywords:
- `zdecydowałem, wybrałem, postanowiłem`
- `klient, faktura, spotkanie`
- `decyzja, wybór`

---

## 🔒 Privacy

- **Local-first:** Wszystko na Twoim kompie
- **No cloud:** Zero zależności
- **Encrypted:** Opcjonalne szyfrowanie
- **GDPR:** Twoje dane = Twoja własność

---

## 📦 Requirements

- Memphis CLI v1.7.6+
- OpenClaw
- Ollama lub inny LLM
- Node.js 18+

---

## 🔗 Links

- **Documentation:** [MEMORY.md](file:///home/memphis/.openclaw/workspace/MEMORY.md)
- **GitHub:** https://github.com/elathoxu-crypto/memphis
- **Discord:** https://discord.gg/clawd
- **ClawHub:** https://clawhub.com

---

**Created by:** Elathoxu Abbylan  
**License:** MIT
