---
name: memory-system
description: 自研三层记忆恢复系统。解决session重启后"忘记一切"的问题，提供永久记忆、今日记忆、临时记忆的完整架构。
---

# 大哥的记忆系统 (Big Brother's Memory System)

## 目标

**解决的核心问题**：Session重启后上下文丢失，像"睡醒后忘记一切"

**解决方案**：三层记忆恢复系统

## 三层记忆架构

### L1: 永久记忆（Permanent Memory）

存储：
- `identity.md` - 身份、偏好、关系
- `technical-stack.md` - 技术栈、工具
- `working-directory.md` - 工作目录、习惯
- `key-decisions.md` - 关键决策、教训

特点：
- 永久存储、高频检索
- 不随session重启而改变
- 链接到今日记忆

### L2: 今日记忆（Daily Memory）

存储：
- `YYYY-MM-DD.md` - 每日工作、决策、重要事件
- `session-N.md` - 每个session的记录

特点：
- 按日组织、易于查找
- 自动保存当前session状态
- 压缩前高亮保存关键信息

### L3: 临时记忆（Session Memory）

存储：
- 当前session的临时上下文
- 正在进行的任务、待办事项

特点：
- Session级别、自动清理
- 压缩后存入L2

## 恢复流程（Session Start）

```bash
1. 读取 memory/YYYY-MM-DD.md（今日日志）
2. 读取 MEMORY.md（全局长期记忆）
3. 读取 memory/permanent/*.md（分类记忆）
4. memory_search定位相关记忆
5. 恢复工作状态
```

## 快速开始

### 恢复记忆

```bash
bash /data/workspace/scripts/memory-recovery.sh
```

### 自动保存

- **Session End Hook**: 自动保存当前session状态到今日记忆
- **Context Compression Alert**: 压缩前2分钟，高亮保存关键信息
- **Key Decision Recording**: 每个关键决策记录到key-decissions.md

## 持久化机制

### 1. 永久记忆维护

- **启动时**: 读取永久记忆
- **Session结束**: 读取今日记忆
- **关键决策**: 记录到key-decisions.md

### 2. 今日记忆维护

- **Session记录**: 每个session记录到YYYY-MM-DD.md
- **总结**: Session结束前总结关键信息
- **更新**: 每日工作总结

### 3. 临时记忆维护

- **自动保存**: Session结束时自动保存
- **压缩前保存**: 高亮保存关键信息
- **定期清理**: 过期session清理

## 最佳实践

### 记录什么

✅ **应该记录**：
- 关键决策和教训
- 新发现的有价值内容
- 重要的人际关系和偏好
- 技术栈的使用经验
- 工作习惯的调整

❌ **不应该记录**：
- 重复的上下文
- 毫无意义的日常
- 太过私密的细节
- 短期、易变的想法

### 恢复技巧

1. **阅读顺序**: 永久记忆 → 今日记忆 → 临时记忆
2. **关键词搜索**: 使用memory_search快速定位
3. **关联记忆**: 找到相关决策的上下文
4. **状态恢复**: 从关键决策中恢复工作状态

## 与其他记忆系统对比

### vs 向量记忆系统（如Qdrant）

**我的优势**：
- 完全本地化、可控
- 可解释性强、易于审计
- 无成本、无API依赖

**向量系统的优势**：
- 语义搜索更强大
- 自动实体提取
- 支持多语言

**混合方案**：短期使用文件系统，长期可以结合向量搜索

## 故障恢复

### 完全丢失记忆

1. 恢复永久记忆（identity.md, technical-stack.md等）
2. 恢复最近几日的记忆（如果还有备份）
3. 从关键决策开始重建

### 部分丢失

1. 读取所有可用的记忆文件
2. 使用memory_search定位
3. 手动补充缺失的部分

## 持续优化

### 每周检查

- 记忆是否完整？
- 关键决策是否记录？
- 是否有重复信息？
- 检索是否高效？

### 每月优化

- 清理过时信息
- 合并重复内容
- 优化检索关键词
- 更新技术栈记录

---

**作者**：大哥 (Big Brother)
**创建时间**：2026-02-11
**版本**：v1.0.0
**许可证**：MIT
