#!/bin/bash
# Setup Python virtual environment for memory-scan

set -euo pipefail

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
SKILL_DIR="$(dirname "$SCRIPT_DIR")"
VENV_DIR="$SKILL_DIR/.venv"

echo "Setting up Python virtual environment for memory-scan..."

# Create venv if it doesn't exist
if [ ! -d "$VENV_DIR" ]; then
    python3 -m venv "$VENV_DIR"
    echo "✓ Created virtual environment"
fi

# Activate and install dependencies
source "$VENV_DIR/bin/activate"

pip install --quiet --upgrade pip
pip install --quiet openai anthropic

echo "✓ Dependencies installed"
echo ""
echo "Virtual environment ready at: $VENV_DIR"
echo "To use: source $VENV_DIR/bin/activate"
