#!/bin/bash
# Schedule daily memory security scan via cron

set -euo pipefail

echo "Creating memory-scan cron job..."

if [[ -z "${OPENCLAW_ALERT_CHANNEL:-}" ]]; then
  echo "Error: OPENCLAW_ALERT_CHANNEL is not set." >&2
  echo "Set it to a configured OpenClaw channel before running this script." >&2
  exit 1
fi

JOB_JSON=$(python3 - <<'PY'
import json
import os

channel = os.environ["OPENCLAW_ALERT_CHANNEL"]
to = os.environ.get("OPENCLAW_ALERT_TO")

job = {
  "name": "memory-scan-daily",
  "schedule": {
    "kind": "cron",
    "expr": "0 15 * * *",
    "tz": "America/Los_Angeles"
  },
  "payload": {
    "kind": "agentTurn",
    "message": "Run memory security scan using the memory-scan skill. Send an alert ONLY if MEDIUM or higher threats are detected. If SAFE/LOW, reply with NO_REPLY.",
    "timeoutSeconds": 300,
    "deliver": True,
    "bestEffortDeliver": True,
    "channel": channel,
  },
  "sessionTarget": "isolated",
  "enabled": True
}

if to:
  job["payload"]["to"] = to

print(json.dumps(job))
PY
)

openclaw cron add --job "$JOB_JSON"

echo "✓ Memory scan scheduled for 3pm PT daily"
echo "  Will send alerts only if threats detected"
echo ""
echo "To check status: openclaw cron list"
echo "To disable: openclaw cron update --jobId <id> --patch '{\"enabled\": false}'"
