# Changelog

All notable changes to Memory-Scan will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/), and this project adheres to [Semantic Versioning](https://semver.org/).

## [1.0.0] - 2026-02-01

### Added

- LLM-powered memory security scanner (`memory-scan.py`)
- Detection of 8 threat categories:
  - Malicious Instructions, Prompt Injection, Credential Leakage, Data Exfiltration
  - Guardrail Bypass, Behavioral Manipulation, Privilege Escalation, Prompt Stealing
- 5-level security scoring: SAFE (90-100), LOW (70-89), MEDIUM (50-69), HIGH (20-49), CRITICAL (0-19)
- Quarantine system with backup and redaction (`quarantine.py`)
- Scheduled scanning via cron job (`schedule-scan.sh`)
- Multiple output formats: human-readable, JSON (`--json`), quiet (`--quiet`)
- Single-file and full-workspace scanning modes
- LLM provider auto-detection (OpenAI / Anthropic)
- Eval framework with test cases (`evals/`)
- Signal alerting integration for MEDIUM+ findings
