---
name: memory-qdrant
description: Local semantic memory with Qdrant and Transformers.js. Store, search, and recall conversation context using vector embeddings (fully local, no API keys).
version: 1.0.10
author: zuiho-kai
homepage: https://github.com/zuiho-kai/openclaw-memory-qdrant
tags: [memory, semantic-search, qdrant, transformers, embeddings, local-ai, vector-db, context]
metadata:
  openclaw:
    requires:
      bins: [node, npm]
---

# memory-qdrant

**Use when** you need your OpenClaw agent to remember and recall information across conversations using semantic search.

Local semantic memory plugin powered by Qdrant vector database and Transformers.js embeddings. Zero configuration, fully local, no API keys required.

## Features

- Semantic search with local Transformers.js embeddings
- In-memory mode (zero config) or persistent Qdrant storage
- Optional auto-capture of conversation context (opt-in, disabled by default)
- Context-aware memory recall
- Fully local, no API keys or external services required

## Installation

```bash
clawhub install memory-qdrant
```

**First-time setup:** This plugin downloads a 25MB embedding model from Hugging Face on first run and may require build tools for native dependencies (sharp, onnxruntime). See [README](https://github.com/zuiho-kai/openclaw-memory-qdrant#readme) for detailed installation requirements.

## Configuration

Enable in your OpenClaw config:

```json
{
  "plugins": {
    "memory-qdrant": {
      "enabled": true
    }
  }
}
```

**Options:**
- `autoCapture` (default: false) - Auto-record conversations. Note: trigger patterns include email/phone regex, so enabling this may capture PII.
- `autoRecall` (default: true) - Auto-inject relevant memories
- `qdrantUrl` (optional) - External Qdrant server (leave empty for in-memory)

## Usage

Three tools available:

**memory_store** - Save information
```javascript
memory_store({
  text: "User prefers Opus for complex tasks",
  category: "preference"
})
```

**memory_search** - Find relevant memories
```javascript
memory_search({
  query: "workflow preferences",
  limit: 5
})
```

**memory_forget** - Delete memories
```javascript
memory_forget({ memoryId: "uuid" })
// or
memory_forget({ query: "text to forget" })
```

## Privacy & Security

- **In-memory mode** (default): Data cleared on restart
- **Qdrant mode**: Data sent to configured server (use trusted servers only)
- **Network**: Downloads ~25MB model from Hugging Face on first run
- **autoCapture**: Disabled by default for privacy. Trigger patterns match emails and phone-like numbers, so enabling autoCapture can capture PII.

## Technical Details

- Vector DB: Qdrant (in-memory or external)
- Embeddings: Xenova/all-MiniLM-L6-v2 (local)
- Module: ES6 with factory function pattern

## Links

- GitHub: https://github.com/zuiho-kai/openclaw-memory-qdrant
- Issues: https://github.com/zuiho-kai/openclaw-memory-qdrant/issues
