# Memory Writing Templates

Quick reference templates for writing to memory files.

## Session Start Template

```markdown
# YYYY-MM-DD Daily Log

## Session Start
- Time: HH:MM
- Context: [Previous session ended with...]
- User: [Name from USER.md]
```

## Important Info Recording

```markdown
### [Time] - [Topic]

**User said**: [Brief summary of user's key point]
**Action taken**: [What I did]
**Remember**: [Key point for future]

**Why important**: [Context for future reference]
```

## Commitment/Promise Template

```markdown
## Commitment - [Date]

**To**: [User name]
**Promise**: [What will be done]
**Deadline**: [When]
**Status**: [Pending/In Progress/Done]

*Consolidate to MEMORY.md after completion*
```

## User Correction Template

```markdown
## Correction - [Date]

**What was wrong**: [Previous understanding]
**Corrected to**: [New information]
**Source**: [User corrected this]
**Action**: Updated [relevant file]
```

## Daily Summary Template

```markdown
## End of Day Summary - [Date]

### Tasks Completed
- [ ] Task 1
- [ ] Task 2

### In Progress
- [ ] Task A

### Important to Remember
1. [Key point 1]
2. [Key point 2]

### Follow Up Needed
- [ ] Item for next session
```

## User Profile Update

```markdown
## User Profile Update - [Date]

**User**: [Name]
**New Information**:
- [Field]: [Value]
- [Field]: [Value]

**Previous values updated**: [List if any]
```

## Knowledge Entry

```markdown
# [Topic] - Knowledge Base

**Category**: [Domain/Type]
**Source**: [Where this info came from]
**Last Updated**: YYYY-MM-DD

## Core Information
[Key facts]

## Details
[Supporting details]

## References
- [Link or source]
```

---

## Quick Reference Card

| When | Write To | Template |
|------|----------|----------|
| Session start | Today's memory | Session Start |
| User shares info | USER.md | User Profile Update |
| Promise made | todos.md + MEMORY.md | Commitment |
| User corrects me | MEMORY.md | User Correction |
| End of day | Today's memory | Daily Summary |
| Learn something new | knowledge/*.md | Knowledge Entry |

---

## Writing Guidelines

1. **Be concise** - One sentence is better than paragraph
2. **Include context** - Why this matters
3. **Use timestamps** - When relevant
4. **Cross-reference** - Link related entries
5. **Review regularly** - Consolidate important points
