#!/bin/bash
# 记忆系统性能监控脚本
# memory_performance_monitor.sh

echo "🔍 记忆系统性能监控"

# 检查向量模型状态
echo "📊 向量模型状态:"
if [ -n "$BAIDU_EMBEDDING_ACTIVE" ] && [ "$BAIDU_EMBEDDING_ACTIVE" = "true" ]; then
    echo "   状态: 激活"
else
    echo "   状态: 未激活"
fi

if [ -n "$EMBEDDING_CACHE_ENABLED" ] && [ "$EMBEDDING_CACHE_ENABLED" = "true" ]; then
    echo "   缓存: 启用"
else
    echo "   缓存: 未启用"
fi

# 检查系统资源使用
echo "💻 系统资源使用:"
MEMORY_USAGE=$(ps aux | grep -v grep | grep -i "python\|embedding" | awk '{sum += $6} END {print sum}')
if [ -n "$MEMORY_USAGE" ]; then
    echo "   记忆相关进程内存使用: $((MEMORY_USAGE / 1024)) MB"
else
    echo "   记忆相关进程内存使用: 0 MB"
fi

# 检查记忆存储大小
echo "💾 记忆存储状态:"
MEMORY_DIR_SIZE=$(du -sh /root/clawd/memory 2>/dev/null | cut -f1)
if [ -n "$MEMORY_DIR_SIZE" ]; then
    echo "   记忆数据大小: $MEMORY_DIR_SIZE"
else
    echo "   记忆数据大小: 0B"
fi

# 检查Git Notes状态
echo "🔄 Git Notes状态:"
if command -v git >/dev/null 2>&1; then
    cd /root/clawd
    BRANCH_STATUS=$(git status --porcelain 2>/dev/null)
    if [ -z "$BRANCH_STATUS" ]; then
        echo "   工作区: 干净"
    else
        echo "   工作区: 有未提交更改"
    fi
else
    echo "   Git: 未安装"
fi

# 检查技能激活状态
echo "⚙️  记忆相关技能状态:"
SKILLS=("memory-baidu-embedding-db" "git-notes-memory" "triple-memory")
for skill in "${SKILLS[@]}"; do
    if [ -d "/root/clawd/skills/$skill" ]; then
        echo "   $skill: ✅ 激活"
    else
        echo "   $skill: ❌ 未安装"
    fi
done

# 白名单技能检查
echo "🔒 白名单技能状态:"
WHITELIST_SKILLS=("ai-sql" "x-api" "oauth-helper")
for skill in "${WHITELIST_SKILLS[@]}"; do
    if [ -d "/root/clawd/skills/$skill" ] && [ -f "/root/clawd/skills/$skill/WHITELISTED.md" ]; then
        echo "   $skill: ✅ 白名单激活"
    elif [ -d "/root/clawd/skills/$skill" ]; then
        echo "   $skill: ⚠️ 已安装但未白名单"
    else
        echo "   $skill: ❌ 未安装"
    fi
done

echo "✅ 记忆系统性能监控完成"