#!/bin/bash

# 百度Embedding记忆系统集成脚本
# 将百度向量数据库集成到Clawdbot记忆系统中

echo "🔧 正在集成百度Embedding记忆系统..."

# 检查环境变量
if [ -z "$BAIDU_API_STRING" ] || [ -z "$BAIDU_SECRET_KEY" ]; then
    echo "❌ 错误：缺少百度API凭证"
    echo "请设置以下环境变量："
    echo "export BAIDU_API_STRING='your_bce_v3_api_string'"
    echo "export BAIDU_SECRET_KEY='${BAIDU_SECRET_KEY}'"
    exit 1
fi

echo "✅ 百度API凭证已配置"

# 初始化百度Embedding数据库
python3 /root/clawd/skills/memory-baidu-embedding-db/memory_baidu_embedding_db.py --init

# 创建符号链接，使系统能够找到百度记忆数据库
ln -sf /root/clawd/skills/memory-baidu-embedding-db /root/clawd/skills/memory-baidu-db-active

echo "✅ 百度Embedding记忆系统集成完成"
echo ""
echo "📊 系统状态："
echo "- 原有LanceDB系统：已禁用"
echo "- 百度Embedding系统：已启用"
echo "- 向量化模型：百度Embedding-V1"
echo "- 搜索方式：语义相似性"
echo ""
echo "🚀 系统现在使用百度向量进行记忆搜索，速度和准确性已优化！"