# 安全配置指南

## 环境变量配置

为了安全使用百度Embedding内存数据库，请按照以下步骤配置环境变量：

### 1. 获取API凭证

1. 访问 [百度千帆大模型平台](https://console.bce.baidu.com/qianfan/)
2. 注册账户并登录
3. 导航到控制台获取API Key和Secret Key
4. 确保您有访问Embedding-V1模型的权限

### 2. 配置环境变量

使用以下命令设置环境变量：

```bash
# 临时设置（当前会话有效）
export BAIDU_API_STRING='${BAIDU_API_STRING}'
export BAIDU_SECRET_KEY='${BAIDU_SECRET_KEY}'

# 永久设置（添加到shell配置文件）
echo 'export BAIDU_API_STRING="${BAIDU_API_STRING}"' >> ~/.bashrc
echo 'export BAIDU_SECRET_KEY="${BAIDU_SECRET_KEY}"' >> ~/.bashrc
source ~/.bashrc
```

### 3. 验证配置

启动应用前，请验证环境变量是否正确设置：

```bash
# 检查环境变量
echo $BAIDU_API_STRING
echo $BAIDU_SECRET_KEY
```

## 安全最佳实践

### 环境变量管理
- 不要在代码中硬编码API密钥
- 使用环境变量或安全的密钥管理系统
- 定期轮换API密钥
- 不要在日志中输出敏感信息

### 权限控制
- 确保配置文件只有授权用户可读
- 使用最小权限原则配置API访问权限
- 定期审查API访问日志

### 数据保护
- 所有内存数据本地存储在SQLite数据库中
- 不上传数据到外部服务
- 数据库文件位于 `~/.clawd/memory_baidu.db`

## 故障排除

### API认证失败
- 症状：认证错误消息
- 解决方案：
  1. 验证环境变量是否正确设置
  2. 检查API密钥是否有效
  3. 确认账户有访问Embedding-V1模型的权限

### 环境变量未设置
- 症状：提示缺少API凭证
- 解决方案：
  1. 按照上述步骤设置环境变量
  2. 重新加载shell配置：`source ~/.bashrc`
  3. 重启应用以加载新的环境变量

## 降级模式

如果未设置API凭证，系统将以降级模式运行：
- 使用关键词匹配而非语义搜索
- 功能受限但仍可存储和检索基本记忆
- 不执行向量化操作