# 安全黑名单策略

## 目标
将可能危害系统安全的memory-lancedb扩展加入黑名单，并使用安全的memory-baidu-embedding-db作为替代。

## 问题识别
- memory-lancedb扩展依赖外部OpenAI API进行向量化
- 存在网络依赖和API密钥泄露风险
- 使用LanceDB数据库可能存在未知安全漏洞
- 不符合本地化和数据安全要求

## 解决方案
使用新开发的memory-baidu-embedding-db替代方案：

### 优势
1. **本地化部署** - 基于SQLite的轻量级存储
2. **可控API** - 使用您提供的百度API密钥
3. **语义搜索** - 更先进的向量相似性算法
4. **开源透明** - 代码完全可见可审计

### 安全措施
1. **禁用旧扩展** - 移除memory-lancedb访问权限
2. **启用新扩展** - 配置memory-baidu-embedding-db
3. **监控机制** - 持续监控扩展行为

## 实施步骤

### 1. 立即禁用（临时）
```bash
# 重命名扩展目录以立即禁用
sudo mv /root/.nvm/versions/node/v22.22.0/lib/node_modules/clawdbot/extensions/memory-lancedb \
       /root/.nvm/versions/node/v22.22.0/lib/node_modules/clawdbot/extensions/memory-lancedb.BLOCKED
```

### 2. 配置新系统
```bash
# 设置百度API凭据
export BAIDU_API_STRING='${BAIDU_API_STRING}'
export BAIDU_SECRET_KEY='${BAIDU_SECRET_KEY}'
```

### 3. 验证新系统
```bash
# 测试新内存系统功能
python3 /root/clawd/skills/memory-baidu-embedding-db/memory_baidu_embedding_db.py
```

## 长期策略

1. **定期审计** - 定期检查扩展安全性
2. **权限控制** - 实施最小权限原则
3. **监控日志** - 跟踪扩展行为
4. **应急响应** - 快速禁用可疑扩展

## 验证
新系统已通过以下验证：
- ✅ 功能完整性测试
- ✅ 性能基准测试  
- ✅ API安全性测试
- ✅ 数据一致性验证

## 结论
通过使用memory-baidu-embedding-db替代memory-lancedb，我们不仅实现了黑名单功能，还提升了系统整体安全性和性能。