# 记忆系统快速入门指南

## 系统概述

记忆系统是一个基于百度Embedding技术的本地化语义记忆系统，提供高性能的语义搜索和记忆管理功能。

## 快速启动

### 1. 环境准备
确保已配置以下环境变量：
```bash
export BAIDU_API_STRING='你的百度API字符串'
export BAIDU_SECRET_KEY='你的百度密钥'
```

### 2. 启动记忆系统
```bash
# 运行最高效能引导
/root/clawd/memory_bootstrap.sh
```

### 3. 验证系统状态
```bash
# 检查系统状态
/root/clawd/memory_performance_monitor.sh
```

## 核心功能

### 语义搜索
系统使用百度Embedding模型进行语义搜索，可以根据含义而非关键词查找记忆。

### 结构化存储
使用Git Notes进行结构化记忆存储，支持版本控制和历史追踪。

### 三层架构
- **短期记忆**: 临时信息存储
- **长期记忆**: 持久化知识库
- **工作记忆**: 当前上下文管理

## 常用命令

### 系统维护
```bash
# 检查系统状态
./memory_maintenance.sh status

# 清理临时文件
./memory_maintenance.sh cleanup

# 创建备份
./memory_maintenance.sh backup

# 优化系统
./memory_maintenance.sh optimize

# 刷新系统
./memory_maintenance.sh refresh
```

### 性能监控
```bash
# 运行性能监控
./memory_performance_monitor.sh
```

## 配置管理

### 主要配置文件
- `MEMORY.md`: 主要记忆配置
- `memory_system_config.json`: 系统配置
- `MEMORY_BOOTSTRAP.md`: 引导配置

### 环境变量
- `BAIDU_EMBEDDING_ACTIVE`: 启用百度Embedding
- `EMBEDDING_CACHE_ENABLED`: 启用向量缓存
- `PERFORMANCE_MODE`: 性能模式 (MAXIMUM)

## 故障排除

### 常见问题
1. **API连接失败**: 检查百度API配置
2. **搜索性能下降**: 运行系统优化
3. **内存不足**: 检查系统资源使用

### 诊断命令
```bash
# 运行完整检查
./memory_maintenance.sh status

# 重新优化系统
./memory_maintenance.sh optimize
```

## 最佳实践

### 性能优化
- 定期运行系统优化
- 保持向量缓存启用
- 定期备份重要数据

### 安全性
- 保护API密钥安全
- 定期检查系统日志
- 保持系统更新

### 维护
- 定期备份记忆数据
- 监控系统性能
- 及时处理警告信息