# Memory Baidu Embedding DB - Quick Start Guide

Get up and running with semantic memory for Clawdbot in under 5 minutes.

## Prerequisites

- Clawdbot installed and running
- Baidu Qianfan API credentials (free tier available)
- Python 3.8+

## Step 1: Get API Credentials

1. Sign up at [Baidu Qianfan Console](https://console.bce.baidu.com/qianfan/)
2. Create API Key and Secret Key
3. Ensure you have access to Embedding-V1 model

## Step 2: Set Environment Variables

```bash
# Replace with your actual credentials
export BAIDU_API_STRING='${BAIDU_API_STRING}'
export BAIDU_SECRET_KEY='${BAIDU_SECRET_KEY}'
```

## Step 3: Install the Skill

Place the skill files in your `~/clawd/skills/memory-baidu-embedding-db/` directory.

## Step 4: Test Installation

```bash
cd ~/clawd/skills/memory-baidu-embedding-db
python3 memory_baidu_embedding_db.py
```

You should see a successful demonstration of all features.

## Basic Usage

```python
from memory_baidu_embedding_db import MemoryBaiduEmbeddingDB

# Initialize
memory_db = MemoryBaiduEmbeddingDB()

# Add a memory
memory_db.add_memory(
    content="The user prefers concise responses",
    tags=["preference", "communication"],
    metadata={"importance": "high"}
)

# Search semantically
results = memory_db.search_memories("How does the user like messages?", limit=3)
for result in results:
    print(f"{result['content']} (relevance: {result['similarity']:.2f})")
```

## Common Use Cases

### Remember User Preferences
```python
memory_db.add_memory(
    content="The user likes Python programming and technical discussions",
    tags=["user-preference", "tech"],
    metadata={"user_id": "user123"}
)
```

### Store Conversation Context
```python
memory_db.add_memory(
    content="The user mentioned working on a machine learning project",
    tags=["conversation", "ml-project"],
    metadata={"timestamp": "2026-01-30T10:30:00Z"}
)
```

### Retrieve Relevant Information
```python
context = memory_db.search_memories("What does the user work on?", limit=5)
relevant_info = [item['content'] for item in context if item['similarity'] > 0.5]
```

## Next Steps

- Read the [Full Tutorial](./TUTORIAL.md) for advanced usage
- Check the [API Reference](./API_REFERENCE.md) for detailed documentation
- See [README](./README.md) for integration examples

## Troubleshooting

**Issue**: API authentication fails
**Solution**: Verify your environment variables are set correctly

**Issue**: Search returns no results
**Solution**: Ensure you have added memories before searching

**Issue**: Slow performance
**Solution**: Use tags to narrow search scope or reduce result limit