# 禁用memory-lancedb扩展

由于您希望将memory-lancedb加入黑名单（禁用它），以下是几种可能的方法：

## 方法1：修改Clawdbot配置
在Clawdbot的主配置文件中，禁用memory-lancedb扩展：

```json
{
  "extensions": {
    "memory-lancedb": {
      "disabled": true
    }
  }
}
```

## 方法2：重命名扩展目录（临时禁用）
```bash
mv /root/.nvm/versions/node/v22.22.0/lib/node_modules/clawdbot/extensions/memory-lancedb \
   /root/.nvm/versions/node/v22.22.0/lib/node_modules/clawdbot/extensions/memory-lancedb.disabled
```

## 方法3：使用我们新开发的memory-baidu-embedding-db替代
我们已经创建了基于百度Embedding的内存系统，它提供了相同的功能但使用不同的技术栈：

- 使用百度Embedding-V1进行向量化（而非OpenAI）
- 使用SQLite进行存储（而非LanceDB）
- 提供相同的API接口
- 更好的语义搜索能力

## 推荐方案
我们建议使用方法3，即使用新开发的memory-baidu-embedding-db完全替代memory-lancedb。这不仅满足了您禁用旧系统的需求，还提供了更好的功能。

新系统已经完成并经过测试，可以完全替代原有的内存管理功能。