# Example: Proactive Nudge

## Scenario

Jake and Sarah have been texting regularly, but the conversation went quiet after Jake's last message. The wingman proactively steps in with timing advice.

---

### Conversation Timeline

**Thursday 8:14 PM — Jake's last message:**
"Haha yeah that movie is underrated. We should watch it sometime"

**Friday 4:30 PM — 20 hours later, no reply**

**Wingman:**

Heads up — Sarah hasn't replied in about 20 hours. Here's my read:

Your last message ("we should watch it sometime") was a soft date suggestion. She might be thinking about how to respond to that, or she just got busy. Either way, don't double text right now.

**What to do:**
- Wait until tomorrow (Saturday morning). If nothing by then, send something completely unrelated to the movie thing.
- Don't reference the silence. Don't say "hey" with nothing else. Don't ask if she got your message.

**If you text tomorrow, try something like:**
> "Just saw the worst pottery I've ever seen at a street fair and thought of you"

It's a callback to an earlier conversation, it's funny, and it has nothing to do with the unanswered message. Takes the pressure off.

**What NOT to do:**
- "Hey, did you see my message?"
- "?"
- Send a meme with no context
- Like one of her Instagram posts hoping she'll notice

**Jake:** She just replied actually

Sarah: "Sorry was slammed at work yesterday! And yes we definitely should, I've been wanting to rewatch it"

**Wingman:**

Called it — she was just busy. And she said "definitely should" which means she's into the idea. Don't let this float — pin it down:

**Chill:**
> "No worries! When works for you?"

**Playful:**
> "Perfect. I'll bring the popcorn, you bring the controversial movie takes"

**Bold:**
> "Friday night. My place or yours?"

She already said yes to the plan, so you can afford to be more direct here. I'd go Bold if you've been on at least one date already, Playful if you haven't.

---

### What Happened Behind the Scenes

1. Wingman detected 20+ hours of silence in a dating conversation
2. Analyzed the last messages — identified a soft date suggestion as the unanswered message
3. Proactively sent timing advice WITHOUT the user asking (no API call)
4. Suggested a specific comeback message using conversation callbacks
5. When Sarah replied, shifted to reply coaching

### Nudge Triggers

| Pattern | Trigger | Action |
|---------|---------|--------|
| No reply 20+ hours | Conversation stall | Timing advice + callback suggestion |
| 3+ messages in a row from user | Over-texting | Ease-up warning |
| She suggests meeting up | Opportunity | Encourage confirming immediately |
| Cancelled plans 2+ times | Red flag | Honest assessment |
| Response time speeding up | Positive signal | Note the momentum |
| Short/one-word replies increasing | Declining interest | Reality check |

### Credits Used: 0

Nudges and coaching run locally. No API calls needed.
