# Example: Date Planning

## Scenario

Jake and Sarah have been texting for a week. Sarah just agreed to go out this weekend. The wingman detects the date confirmation and proactively suggests ideas.

---

### Conversation

Sarah: "Okay fine you've convinced me. Saturday works, what are we doing?"

Jake: "Let me think on it and get back to you"

**Wingman:**

A date just got confirmed with Sarah for Saturday. Nice work. Let me pull together some ideas based on what I know about her.

From your conversations, here's what I'm working with:
- She's into pottery and art (went to that studio you mentioned)
- Coffee snob (will judge your order, her words)
- Has a dog named Biscuit
- Mentioned a rooftop bar in her profile photos
- She responds best to your playful messages — keep that energy in person

Here are three ideas:

**1. Coffee shop + art walk**
Hit up a specialty coffee place (you'll score points for knowing a spot), then walk through the gallery district. Low pressure, easy to extend if it's going well.
- Cost: ~$20-30
- Duration: 1.5-2 hours
- Why it works: Plays to her coffee thing and art interest without being a "dinner interview"

**2. Dog-friendly brewery**
Bring the dogs, grab a table outside. Built-in icebreaker (the dogs), casual vibe, and you already know she's a dog person.
- Cost: ~$25-40
- Duration: 2-3 hours
- Why it works: Dogs reduce first-date awkwardness by about 90%. Plus you get to meet Biscuit.

**3. Pottery class for two**
That studio she went to does Saturday afternoon drop-in sessions. You'll both be terrible and it'll be funny.
- Cost: ~$45-60 per person
- Duration: 2 hours
- Why it works: Activity dates > sitting across a table. She already brought it up so it's a natural callback.

My pick: **Option 1** for a first date. Low cost commitment, easy to bail if it's weird, and easy to extend ("want to grab food?") if it's not. Save pottery for date two — that's your ace.

**Backup plan:** If the weather's bad, swap the art walk for a record store or bookshop. Same vibe, indoors.

**Jake:** Going with option 1. How should I tell her?

**Wingman:**

Keep it specific — "Saturday works" energy, not "what do you think about maybe..." energy:

> "Saturday 2pm. I know a coffee spot you're going to have opinions about. Wear walking shoes."

Confident, gives her just enough to be curious, doesn't over-explain. She asked "what are we doing" — she wants you to have a plan.

---

### What Happened Behind the Scenes

1. Wingman detected a date confirmation in the conversation
2. Analyzed full conversation history for shared interests and personality cues
3. Generated three date ideas tailored to Sarah's known preferences
4. Ranked them with reasoning based on relationship stage (first date)
5. When Jake asked how to tell her, provided a reply that matched her communication style

### Credits Used: 0

Date planning runs locally — the wingman uses conversation context it already has. No API calls needed.
