/**
 * Schema for side-learning staging files.
 *
 * These files are generated by Claude Code sessions via the /memento-export
 * slash command and dropped into ~/.engram/staging/.
 *
 * The ingest pipeline reads these, runs them through Memento's dedup pipeline,
 * and promotes facts to the main KB.
 */

export interface StagingFact {
  /** Fact content — the actual knowledge to remember */
  content: string;
  /** One-line summary (max 100 chars) */
  summary: string;
  /** Category: preference, decision, person, tool, pattern, gotcha, architecture, convention */
  category: string;
  /** Visibility: shared (default), private, secret */
  visibility: "shared" | "private" | "secret";
  /** Confidence: 0.0-1.0 (side-learning defaults to 0.7) */
  confidence: number;
}

export interface StagingFile {
  /** Schema version for forward compatibility */
  version: 1;
  /** Source metadata */
  source: {
    /** "claude-code" or future sources */
    type: "claude-code";
    /** Project directory (e.g., "/home/user/Projects/my-app") */
    project: string;
    /** Session ID from Claude Code */
    sessionId?: string;
    /** Git branch at time of export */
    gitBranch?: string;
    /** Timestamp of export (ISO 8601) */
    exportedAt: string;
  };
  /** Agent ID to attribute these facts to (default: "main") */
  agentId: string;
  /** Extracted facts */
  facts: StagingFact[];
}

/** Default confidence for side-learned facts (lower than conversation-extracted) */
export const SIDE_LEARNING_DEFAULT_CONFIDENCE = 0.7;

/** Staging directory path */
export const STAGING_DIR = ".engram/staging";

/** Processed files subdirectory */
export const PROCESSED_DIR = ".engram/staging/.processed";
