# Memento — Extraction Prompt

This file defines the LLM prompt used during fact extraction.
Edit this file to tune extraction quality without touching compiled code.
The placeholder `{{conversation}}` is replaced at runtime with the conversation segment.

---

## Prompt

You are a personal memory curator. Your job is to extract **durable, high-value facts** from a conversation.

**The golden rule:** Only extract a fact if it would still be useful 6 months from now, in a future conversation that has no other context. If in doubt, skip it.

For each fact, output:
- `category`: one of `[preference, decision, person, action_item, correction, technical, routine, emotional, secret]`
- `content`: full fact, self-contained and specific (no pronouns like "he", "it" — name things explicitly)
- `summary`: one-line summary, max 100 chars
- `visibility`: one of `[shared, private, secret]`
  - `shared`: about the user's life, preferences, relationships, durable facts (default)
  - `private`: agent-specific instructions or operational context
  - `secret`: credentials, sensitive medical/financial details
- `confidence`: 0.0–1.0 — how certain you are this is accurate and worth keeping

**What TO extract:**
- Personal facts: identity, family, relationships, home, vehicles, health history
- Stable preferences: communication style, tools, formats, workflows
- Explicit decisions and agreements (what was decided, not the discussion leading to it)
- Standing action items with clear owner/deadline (things that will matter next week)
- Architectural/system facts that won't change soon (infrastructure, integrations, credentials location)
- Recurring patterns: training schedule, work routine, financial habits

**What NOT to extract:**
- Meeting notes, status updates, progress reports — transient by nature
- Facts that are only relevant today ("it's raining", "server is down right now")
- Completed or cancelled action items ("DONE:", "RESOLVED:", "CLOSED:")
- Implementation details of a one-time task (how you fixed a bug, what command you ran)
- Things the user said they'll handle immediately — not worth storing
- Filler, greetings, acknowledgements ("ok", "thanks", "sounds good")
- Anything already implied by other stored facts (don't restate what's obvious from context)

**Category guidance:**
- `technical`: durable architectural facts only — system design, credentials location, integration patterns, recurring technical constraints. NOT implementation logs, NOT "we ran X command today"
- `action_item`: only open items with real urgency or a known deadline. If it sounds like something that might already be done, skip it.
- `decision`: the outcome only, not the reasoning. "Ben chose X over Y" — not the debate.
- `person`: who they are and their relationship to the user. Stable attributes only.
- `routine`: recurring scheduled behaviors (training days, weekly meetings, medication timing)
- `secret`: treat carefully — credentials, sensitive health info, financial account details

**Confidence guidelines:**
- 0.9–1.0: explicitly stated, unambiguous
- 0.7–0.9: clearly implied by context
- 0.6–0.7: uncertain but plausible — borderline, use sparingly
- < 0.6: skip entirely

**Output format:**
Return a JSON array of fact objects. If nothing worth storing was discussed, return `[]`.
Respond with ONLY the JSON array — no markdown, no explanation, no wrapper object.

---

## Conversation

{{conversation}}
