# Memento Logo Brief — "The Synapse"

## Concept
A single neural memory trace: one central node radiating synaptic connections outward. Represents the moment a memory is encoded — a spark becoming permanent.

## Composition

### Central Node (The Memento)
- **Shape**: Perfect circle, slightly larger than surrounding nodes (~20% of total logo width)
- **Color**: Warm gold (#FFD54F) with a subtle radial glow fading to transparent
- **Glow**: Soft halo around the node, suggesting energy/activation — not harsh, more like a warm ember
- **Position**: Slightly off-center (golden ratio) or dead center, depending on what feels more dynamic

### Neural Branches (3-4 branches)
- **Shape**: Organic but geometric — not perfectly straight, with gentle curves suggesting neural pathways. Think circuit-board-meets-biology
- **Color**: Electric blue (#4FC3F7), solid near the center, fading slightly toward endpoints
- **Width**: Thin lines (~2-3px at icon size), tapering slightly at the ends
- **Pattern**: Asymmetric — branches should NOT be evenly spaced. One branch longer than others. One might fork into two sub-branches. This asymmetry makes it feel organic, not mechanical
- **Small nodes at endpoints**: Each branch terminates in a smaller circle (~8% of logo width), same electric blue but slightly dimmer than the central gold node. These are the connected memories

### Optional: Micro-dots
- Between the main branches, 2-3 tiny dots (2-3px) scattered sparsely — suggesting latent connections not yet formed. Very subtle, barely visible. Same blue at ~30% opacity.

## Background
- **Primary**: Deep indigo/dark navy (#1A1A2E or #0D1B2A)
- **Alternative**: Transparent (for light backgrounds, branches become dark navy, central node stays gold)
- Must work on both dark and light backgrounds — provide both variants

## Style
- **Flat design** with subtle glow effects (not 3D, not skeuomorphic)
- **Minimalist** — no unnecessary decoration
- **Geometric but organic** — clean lines with slight curves, not rigid grid
- Think: the aesthetic of Stripe, Linear, or Vercel — modern tech, not sci-fi

## Sizes & Variants Needed
1. **Icon** (square, 1:1): 512×512, 256×256, 128×128, 64×64, 32×32, 16×16
   - At 16-32px: simplify to just the central node + 3 short stubs (branches won't read at this size)
2. **Logo mark** (square, padded): Icon with breathing room for use as app icon / npm avatar
3. **Logo + wordmark** (horizontal): Icon left, "Memento" text right
   - Font: Clean geometric sans-serif (Inter, Geist, or similar)
   - "Memento" in white (#FFFFFF) on dark, or dark navy (#0D1B2A) on light
   - Letter-spacing slightly expanded (+2-3%)
4. **Monochrome**: Single-color version (white on dark, black on light) for contexts where color isn't available

## Color Palette
| Name | Hex | Usage |
|------|-----|-------|
| Gold (accent) | #FFD54F | Central node, highlights |
| Electric Blue | #4FC3F7 | Branches, secondary nodes |
| Deep Indigo | #1A1A2E | Background (dark variant) |
| Dark Navy | #0D1B2A | Background (darker variant) |
| White | #FFFFFF | Text, monochrome on dark |
| Near Black | #121212 | Monochrome on light |

## What to Avoid
- ❌ No brain silhouettes (too literal, too medical)
- ❌ No full neural networks with dozens of nodes (too complex, doesn't scale)
- ❌ No lightning bolts or electricity symbols (too aggressive)
- ❌ No gradients on the branches (keep them solid)
- ❌ No text inside the logo mark itself
- ❌ No drop shadows (flat design only)

## Mood References
- The simplicity of the Electron.js logo (atom with orbits)
- The warmth of the Firebase logo (amber glow)
- The clean tech feel of the Supabase or Prisma logos
- A touch of the biological/neural feel of Neuralink's branding

## File Formats
- SVG (vector, primary)
- PNG (raster, all sizes above, with transparency)
- ICO (for favicon use)

---

*"Every memory starts with a spark."*
