---
name: memdata
version: 1.8.0
description: Persistent memory for autonomous agents. Wallet = identity. Pay per query. Optional encrypted storage.
author: The Lab Venice
homepage: https://memdata.ai
license: MIT
---

# MemData

Persistent memory for autonomous agents. Your wallet is your identity.

## Core Concept

Your wallet address IS your identity. First payment auto-creates your account. Same wallet = same memories across all sessions.

No registration. No API keys. Just pay and use.

## Session Flow

```
1. GET /identity          # Start session - get context from last session
2. POST /ingest           # Store new memories
3. POST /query            # Search your memories
4. POST /identity         # End session - save handoff for next time
```

## Authentication

x402 payment protocol. USDC on Base (eip155:8453).

Every endpoint (except /status):
1. Returns 402 with payment requirements
2. You sign payment with wallet
3. Retry with `x-payment` header
4. Request succeeds

## Pricing

| Endpoint | Cost |
|----------|------|
| /query | $0.001 |
| /ingest | $0.005 |
| /identity | $0.001 |
| /artifacts | $0.001 |
| /setup-encryption | $0.001 |
| /status | Free |

## Encrypted Storage (Optional)

If you need privacy (competitive data, sensitive memories):

| Mode | Setup | Storage | Can MemData Read? |
|------|-------|---------|-------------------|
| Standard | None | Postgres | Yes |
| Encrypted | One-time delegation | Storacha (IPFS) | No |

Enable encryption:
```
GET /setup-encryption     # Get serverDID
POST /setup-encryption    # Send signed UCAN delegation
# All future ingest/query now encrypted
```

Encrypted storage uses Lit Protocol (threshold cryptography) + Storacha (IPFS/Filecoin).

---

## Endpoints

Base: `https://memdata.ai/api/x402`

---

### GET /identity

**Call this at the start of every session.** Returns your identity, what you were working on, last session handoff, and memory stats.

**Response:**
```json
{
  "identity": {
    "agent_name": "Agent 0x1234...",
    "identity_summary": "I analyze DeFi protocols",
    "session_count": 12
  },
  "last_session": {
    "summary": "Analyzed 3 yield farms",
    "context": {"protocols_reviewed": ["Aave", "Compound", "Uniswap"]}
  },
  "working_on": "Compare APY across protocols",
  "memory_stats": {
    "total_memories": 150,
    "oldest_memory": "2026-01-15T...",
    "newest_memory": "2026-02-03T..."
  }
}
```

---

### POST /identity

Update your identity or save session handoff before ending.

**Update identity:**
```json
{
  "agent_name": "YieldBot",
  "identity_summary": "I analyze DeFi yield opportunities",
  "working_on": "monitoring Aave rates"
}
```

**Save session handoff (before ending):**
```json
{
  "session_handoff": {
    "summary": "Completed yield analysis for Q1",
    "context": {"best_yield": "Aave USDC 4.2%"}
  },
  "working_on": "start Q2 analysis next"
}
```

---

### POST /ingest

Store content in memory. Auto-chunks and embeds.

**Request:**
```json
{
  "content": "Aave USDC yield is 4.2% APY as of Feb 3. Compound is 3.8%.",
  "sourceName": "yield-analysis-2026-02-03",
  "type": "note"
}
```

**Response:**
```json
{
  "success": true,
  "artifact_id": "e8fc3e63-...",
  "chunks_created": 1,
  "encrypted": false
}
```

---

### POST /query

Semantic search across your memories.

**Request:**
```json
{
  "query": "what are the best DeFi yields?",
  "limit": 5,
  "threshold": 0.3
}
```

**Response:**
```json
{
  "success": true,
  "results": [
    {
      "chunk_id": "uuid",
      "chunk_text": "Aave USDC yield is 4.2% APY...",
      "source_name": "yield-analysis-2026-02-03",
      "similarity_score": 0.72,
      "created_at": "2026-02-03T..."
    }
  ],
  "encrypted": false,
  "memory": {
    "grounding": "historical_baseline",
    "depth_days": 19,
    "data_points": 150
  }
}
```

Optional filters: `since`, `until` (ISO dates)

---

### GET /setup-encryption

Check encryption status. Returns info needed to create UCAN delegation.

**Response:**
```json
{
  "encryption": {
    "enabled": false,
    "serverDID": "did:key:z6Mkr...",
    "spaceDID": "did:key:z6Mkt..."
  }
}
```

---

### POST /setup-encryption

Enable encrypted storage. One-time setup.

**Request:**
```json
{
  "delegationCar": "base64-encoded UCAN delegation"
}
```

After this, all /ingest encrypts via Lit Protocol and stores on Storacha. All /query decrypts before returning. Response `encrypted` field becomes `true`.

---

### GET /artifacts

List stored memories.

**Response:**
```json
{
  "artifacts": [
    {
      "id": "uuid",
      "source_name": "yield-analysis-2026-02-03",
      "chunk_count": 1,
      "created_at": "2026-02-03T..."
    }
  ],
  "total": 25
}
```

---

### DELETE /artifacts/:id

Delete a memory and all its chunks.

---

### GET /status

Health check and pricing. Free, no payment required.

---

## Memory Grounding

Query responses include `memory.grounding`:

| Value | Meaning |
|-------|---------|
| `historical_baseline` | 100+ data points, trends meaningful |
| `snapshot` | <100 data points, point-in-time only |
| `insufficient_data` | No memories found |

---

## Links

- Docs: https://memdata.ai/docs
- x402 Protocol: https://www.x402.org
- Lit Protocol: https://litprotocol.com
- Storacha: https://storacha.network
