---
name: mem0
description: >-
  Intelligent memory layer for Clawdbot using Mem0. Provides semantic search and automatic storage of user preferences, patterns, and context across conversations. Use when (1) User explicitly says "remember this", (2) Learning user preferences or patterns during conversation, (3) Searching for past context about user's choices/preferences, (4) Building adaptive responses based on learned user behavior. Complements MEMORY.md (structured facts) with dynamic, conversational memory (learned preferences, patterns, adaptive context).
---

# Mem0 Memory Integration

Mem0 adds an intelligent, adaptive memory layer to Clawdbot that automatically learns and recalls user preferences, patterns, and context across all interactions.

## Core Workflow

### 1. Search Before Responding
Before answering user questions, search mem0 for relevant context:

```bash
node scripts/mem0-search.js "user preferences" --limit=3
```

Use retrieved memories to:
- Personalize responses
- Remember preferences
- Recall past patterns
- Adapt communication style

### 2. Store After Interactions

**Explicit Storage** (when user says "remember this"):
```bash
node scripts/mem0-add.js "Abhay prefers concise updates"
```

**Conversation Storage** (for context learning):
```bash
# Pass messages as JSON
node scripts/mem0-add.js --messages='[{"role":"user","content":"I like brief updates"},{"role":"assistant","content":"Got it!"}]'
```

## Available Commands

### Search Memories
```bash
node scripts/mem0-search.js "query text" [--limit=3] [--user=abhay]
```

Searches semantically across stored memories. Returns relevant memories ranked by relevance.

### Add Memory
```bash
# Simple text
node scripts/mem0-add.js "memory text" [--user=abhay]

# Conversation messages (auto-extracts memories)
node scripts/mem0-add.js --messages='[{...}]' [--user=abhay]
```

Mem0's LLM automatically extracts, deduplicates, and merges related memories.

### List All Memories
```bash
node scripts/mem0-list.js [--user=abhay]
```

Shows all stored memories for the user with IDs and creation dates.

### Delete Memories
```bash
# Delete specific memory
node scripts/mem0-delete.js <memory_id>

# Delete all memories for user
node scripts/mem0-delete.js --all --user=abhay
```

## What to Store vs Not Store

### ✅ Store These:
- **Explicit requests**: "Remember that I..."
- **Preferences**: Communication style, format choices
- **Personal context**: Work info, interests, family (non-sensitive)
- **Usage patterns**: Frequent requests, timing preferences
- **Corrections**: When user corrects your mistakes
- **Adaptive facts**: Current projects, recent interests

### ❌ Don't Store:
- Secrets, passwords, API keys
- Temporary context (unless explicitly requested)
- System errors or debug info
- Information already in MEMORY.md (avoid duplication)

## Complementing Clawdbot Memory

**Clawdbot MEMORY.md** (Structured, Deliberate):
- Permanent facts: Name = Abhay, Location = Singapore
- Reference data: Email, blog URL, Twitter handle
- Structured knowledge: Project details, credentials

**Mem0** (Dynamic, Learned):
- Preferences: "Abhay prefers concise updates"
- Patterns: "Usually asks for bus info at 8:30am"
- Adaptive context: "Currently interested in AI news"
- Behavioral: "Likes direct answers, minimal fluff"

**Use both together**: Check MEMORY.md for facts, check mem0 for preferences/patterns.

## Performance Benefits

- **+26% accuracy** over OpenAI Memory (LOCOMO benchmark)
- **91% faster** than full-context retrieval
- **90% fewer tokens** than including all conversation history
- **Sub-50ms** semantic search retrieval

## Configuration

Located in `scripts/mem0-config.js`:

```javascript
{
  embedder: "openai/text-embedding-3-small",
  llm: "openai/gpt-4o-mini",
  vectorStore: "memory" (local),
  historyDb: "~/.mem0/history.db",
  userId: "abhay"
}
```

Uses Clawdbot's OpenAI API key from environment (`OPENAI_API_KEY`).

## Integration Patterns

For detailed workflow patterns, error handling, and best practices, see:
- `references/integration-patterns.md`

## Programmatic Use

All scripts support `JSON_OUTPUT` environment variable for programmatic access:

```bash
JSON_OUTPUT=1 node scripts/mem0-search.js "query"
```

Returns JSON after human-readable output (look for `---JSON---` marker).

## Resources

### scripts/
- `mem0-config.js` - Configuration and instance initialization
- `mem0-search.js` - Search memories semantically
- `mem0-add.js` - Add new memories
- `mem0-list.js` - List all memories
- `mem0-delete.js` - Delete memories

### references/
- `integration-patterns.md` - Detailed best practices and patterns
