# ZeeLin Song Generator

AI 音乐生成技能 - 从创意到完整歌曲

## 功能特点

- 🎵 **一句话生成歌曲**: 输入创意描述，自动生成完整歌曲
- 📝 **智能歌词创作**: 使用 Google Gemini 生成高质量歌词
- 🎼 **专业音乐合成**: 通过 Suno AI 生成带人声/纯音乐的完整歌曲
- 🎭 **多风格支持**: 流行、摇滚、电子、民谣、古风等各种风格
- 🌍 **中英双语**: 支持中文和英文创意输入

## 使用示例

```
用户: 帮我生成一首关于秋天落叶的忧伤民谣
Agent: [调用 API 生成歌词]
Agent: 我生成了《落叶时节》的歌词，请查看...
用户: 很好，就用这个
Agent: [调用 API 生成音乐]
Agent: ✅ 已生成两个版本，点击播放...
```

## 技术架构

```
用户创意 → MelodyLab API → Google Gemini (歌词) → Suno AI (音乐) → 音频文件
```

## 隐私说明

- **数据传输**: 创意描述和歌词通过 HTTPS 发送至 melodylab.top
- **数据存储**: 不永久存储用户输入，日志保留 7 天
- **第三方服务**: 使用 Google Gemini 和 Suno AI，受其隐私政策约束
- **音频托管**: 生成的音频文件由 Suno CDN 托管

⚠️ **建议**: 避免在创意描述中包含敏感个人信息（姓名、地址、身份证号等）

## 限制与配额

- 生成速度受上游 API 影响（歌词 30-90s，音乐 60-180s）
- 可能存在每日/每月配额限制
- 高峰时段可能需要排队

## 故障排查

### 常见错误

**403 用户已被封禁**
- 原因: API 配额耗尽或账户受限
- 解决: 等待配额重置或联系开发者

**429 Too Many Requests**
- 原因: 请求过于频繁
- 解决: 等待 60 秒后重试

**超时错误**
- 原因: 上游 API 响应慢
- 解决: 稍后重试，避免在高峰时段使用

## 开发者信息

- **作者**: 刘东江 (@lidngjing317853)
- **License**: MIT
- **主页**: https://melodylab.top
- **版本**: 1.0.2

## 致谢

- Google Gemini - 歌词生成
- Suno AI - 音乐合成
- OpenClaw 社区

---

**免责声明**: 本技能仅供个人娱乐和学习使用。生成的音乐内容由 AI 创作，使用时请遵守相关版权法律法规。
