# Privacy Policy - ZeeLin Song Generator

**Last Updated**: 2026-03-03  
**Effective Date**: 2026-03-03

## Overview

ZeeLin Song Generator ("the Skill") is an OpenClaw skill that generates music and lyrics by calling external APIs. This privacy policy explains how user data is handled.

## Data Collection

### What We Collect
- Creative ideas/descriptions you provide
- Style preferences (music style, emotional style)
- Vocal mode preferences (vocal/instrumental)
- Edited lyrics (if you modify generated lyrics)

### What We Don't Collect
- Personal identifiable information (unless you include it in your input)
- Account credentials
- Device information
- Location data

## Data Usage

### Primary Use
User-provided content is sent to:
1. **Google Gemini API** - for lyrics generation
2. **Suno AI API** - for music synthesis

### Processing Location
- API endpoint: `https://melodylab.top` (hosted on Vercel)
- Gemini API: Google Cloud Platform
- Suno AI: Suno's infrastructure

### Data Flow
```
User Input → MelodyLab API → Gemini (lyrics) → Suno (music) → User
```

## Data Retention

- **Request Logs**: Retained for 7 days for debugging and error analysis
- **User Input**: Not permanently stored on MelodyLab servers
- **Generated Content**: Audio files are hosted by Suno AI CDN; retention policy is governed by Suno's terms

## Third-Party Services

### Google Gemini
- **Purpose**: Generate lyrics from creative ideas
- **Privacy Policy**: https://policies.google.com/privacy
- **Data Handling**: Subject to Google's AI services terms

### Suno AI
- **Purpose**: Generate music with vocals/instrumentals
- **Privacy Policy**: https://suno.ai/privacy
- **Data Handling**: Subject to Suno's terms of service

## Data Security

- All API calls use HTTPS encryption (TLS 1.3)
- No authentication tokens or API keys are stored in the skill
- Backend API keys are securely managed via environment variables

## User Rights

You have the right to:
- Know what data is being sent to external services
- Request deletion of logs (contact developer)
- Opt out by not using the skill

## Data Sharing

We **do not**:
- Sell user data
- Share data with advertisers
- Use data for marketing purposes
- Train models on user input (beyond Gemini/Suno's own policies)

## Children's Privacy

This skill is not directed to children under 13. If you believe a child has used this skill, please contact the developer.

## Changes to This Policy

We may update this policy. Check the "Last Updated" date above. Continued use after changes constitutes acceptance.

## Contact

For privacy concerns or data deletion requests:
- **Developer**: 刘东江 (@lidngjing317853)
- **Email**: [Provide if available]
- **Homepage**: https://melodylab.top

## Legal Basis (GDPR)

For EU users, data processing is based on:
- **Consent**: By using the skill, you consent to this data processing
- **Legitimate Interest**: Providing the music generation service

## Your Responsibilities

To protect your privacy:
- ❌ Do not include personal information (names, addresses, ID numbers) in creative descriptions
- ❌ Do not submit confidential or proprietary content
- ✅ Review generated lyrics before confirming
- ✅ Use generic descriptions when possible

---

**Disclaimer**: This skill relies on third-party AI services. While we strive to protect your data, we cannot guarantee the practices of Gemini or Suno beyond their published policies.
