---
name: meeting-score
description: 会议议题评分系统。会议主持人提供议题名称、材料链接和评委名单，自动在飞书多维表格中创建评分表。每位评委独立打分（打分维度一（替换为实际）、打分维度二（替换为实际）、打分维度三（替换为实际）），打分范围 H/M/L，评分完成后主持人可查看各议题平均分汇总。
metadata: { "openclaw": { "emoji": "📊" } }
---

# Meeting Score Skill — 会议议题评分系统

## 功能概述

为会议主持人提供一套完整的议题评分工作流：

1. **初始化** — 主持人提供议题 + 材料链接 + 评委名单，自动创建飞书多维表格
2. **打分** — 每位评委独立打分（仅可见自己的打分记录）
3. **汇总** — 所有评委完成后，主持人查看各议题平均分报告

---

## 数据结构设计

### 表1：议题列表（主持人视图）

| 字段名 | 类型 | 说明 |
|--------|------|------|
| 议题名称 | 文本 | 汇报议题标题 |
| 材料链接 | 超链接 | 议题相关文档链接 |
| 状态 | 单选 | 待评分 / 评分中 / 已完成 |
| 维度一均分 | 数字 | 自动计算（所有评委该维度平均），**维度名可自定义**，如：打分维度一（替换为实际） |
| 维度二均分 | 数字 | 自动计算，**维度名可自定义**，如：打分维度二（替换为实际） |
| 维度三均分 | 数字 | 自动计算，**维度名可自定义**，如：打分维度三（替换为实际） |
| 综合总分均分 | 数字 | 三维度均分之和 |

### 表2：评分记录（评委打分视图）

| 字段名 | 类型 | 说明 |
|--------|------|------|
| 议题名称 | 文本 | 关联议题 |
| 评委姓名 | 文本 | 打分人 |
| 维度一 | 单选 | H(5分) / M(3分) / L(1分)，**维度名可自定义** |
| 维度二 | 单选 | H(5分) / M(3分) / L(1分)，**维度名可自定义** |
| 维度三 | 单选 | H(5分) / M(3分) / L(1分)，**维度名可自定义** |
| 小计 | 数字 | 三项分值之和（自动计算） |
| 打分时间 | 日期 | 记录时间 |

---

## 执行步骤

### 【Step 1】初始化评分表

当主持人说"创建评分表"、"新建会议评分"或提供议题信息时执行：

**输入信息：**
- 议题列表（名称 + 材料链接）
- 评委名单（姓名列表）

**执行操作：**

1. 使用 `feishu_bitable_create` 创建多维表格，命名为「{会议名称}_议题评分」

2. 创建**议题列表**表（表1），添加字段：
   - 议题名称（文本，主键）
   - 材料链接（超链接）
   - 状态（单选：待评分/评分中/已完成）
   - 维度一均分（数字，**若主持人指定了维度名则使用实际名称，否则默认"维度一"**）
   - 维度二均分（数字，同上）
   - 维度三均分（数字，同上）
   - 综合总分均分（数字）

3. 创建**评分记录**表（表2），添加字段：
   - 议题名称（文本）
   - 评委姓名（文本）
   - 维度一（单选：H/M/L，**维度名同上，可自定义**）
   - 维度二（单选：H/M/L，**维度名同上，可自定义**）
   - 维度三（单选：H/M/L，**维度名同上，可自定义**）
   - 小计（数字）
   - 备注（文本）

   > ⚠️ **注意**：评分记录表创建后，系统默认的「多行文本」主键字段保留（用于显示），其余默认生成的「单选」「日期」「附件」字段需删除，调用 DELETE /fields/{field_id} 清理。

   > ⚠️ **注意**：飞书多维表格创建后默认会生成若干空白行以及「单选」「日期」「附件」等默认字段，初始化时需要：
   > 1. 删除默认多余字段（单选/日期/附件）：逐个调用 DELETE /fields/{field_id}
   > 2. 删除默认空白行：读取所有记录后逐条调用 DELETE /records/{record_id} 删除主键为空的行
   > 两步操作确保表格整洁，只保留业务所需字段和数据。

   > 💡 **维度名自定义说明**：主持人在初始化时可指定三个维度的实际名称，例如：
   > `"维度一=打分维度一（替换为实际），维度二=打分维度二（替换为实际），维度三=打分维度三（替换为实际）"`
   > 若未指定，默认使用「维度一/维度二/维度三」。

4. 在表2中为每个「评委 × 议题」组合预创建空白记录行（方便评委直接填写）

5. **配置「评分记录」表的行级高级权限（每人仅见自己的行）：**

   飞书多维表格支持「高级权限」功能，可限制每个协作者只能查看/编辑与自己相关的行。由于 API 暂不支持直接配置行级权限，**需主持人在表格中手动操作**（初始化后提示主持人）：

   **操作步骤（主持人完成表格创建后执行）：**
   
   ```
   ① 打开「评分记录」表
   ② 点击右上角「...」→「高级权限」
   ③ 开启「高级权限」
   ④ 点击「添加规则」
   ⑤ 设置规则：
      - 条件：「评委姓名」字段 = 当前用户姓名
      - 权限：可查看、可编辑（仅匹配行）
   ⑥ 将规则应用范围设为「协作者」
   ⑦ 保存
   ```

   完成后每位评委打开表格只会看到自己姓名对应的行，无法查看其他评委的打分。

   > ⚠️ **重要提示**：飞书高级权限中「当前用户」的匹配依赖「评委姓名」字段与飞书账号姓名一致。
   > 若评委的飞书显示名称与填写的评委姓名不同，需在初始化时确认姓名一致，或使用「成员」类型字段（关联飞书用户）以确保精确匹配。

6. 返回表格链接，并提示主持人配置高级权限：
   ```
   ✅ 评分表已创建！
   
   📋 表格链接：{url}
   
   ⚠️ 请主持人完成以下配置（约1分钟）：
   打开「评分记录」表 → 右上角「...」→「高级权限」
   → 添加规则：评委姓名 = 当前用户 → 保存
   配置完成后每位评委只能看到自己的打分行。
   
   评委操作说明：
   - 打开表格 → 切换到「评分记录」表
   - 找到自己姓名对应的行，填写 H/M/L
   - H=5分（高）  M=3分（中）  L=1分（低）
   
   主持人说"查看汇总"可获取各议题平均分报告。
   ```

---

### 【Step 2】评委打分

当评委说"我要打分"、"提交打分"时：

**输入：**
- 评委姓名
- 议题名称
- 三个维度的评分（H/M/L）

**分值换算：**
- H → 5分
- M → 3分
- L → 1分

**执行：**
1. 在表2中找到对应评委+议题的记录（用 `feishu_bitable_list_records` 读取）
2. 用 `feishu_bitable_update_record` 更新三个维度的评分和打分时间
3. **立即计算并回写小计**（见下方计算规则）
4. 确认消息：`✅ {评委} 对「{议题}」的打分已记录，小计：{小计}分`

---

### 【Step 2.5】计算并回写小计（每次打分后自动执行）

**触发时机：** 每当有评委完成打分（Step 2）后，立即执行。

**计算规则：**

```
scoreMap = { "H（5分）": 5, "M（3分）": 3, "L（1分）": 1 }

小计 = scoreMap[维度一] + scoreMap[维度二] + scoreMap[维度三]
```

**执行步骤：**

1. 读取该条评分记录的三个维度值
2. 按 scoreMap 换算为数字（H=5, M=3, L=1）
3. 将三项相加得到小计（最高15分）
4. 用 `feishu_bitable_update_record` 将小计写回该记录的「小计」字段
5. 同步更新议题列表表（表1）中对应议题的均分：
   - 读取该议题所有已打分的记录
   - 分别计算三个维度的平均分（保留1位小数）
   - 计算综合总分均分（三维度均分之和）
   - 用 `feishu_bitable_update_record` 更新表1对应行的均分字段
   - 若该议题所有评委均已完成打分，将状态更新为「已完成」

**示例：**
```
张三打分：维度一=H, 维度二=M, 维度三=L
小计 = 5 + 3 + 1 = 9

李四打分：维度一=H, 维度二=H, 维度三=H
小计 = 5 + 5 + 5 = 15

该议题维度一均分 = (5+5)/2 = 5.0
该议题维度二均分 = (3+5)/2 = 4.0
该议题维度三均分 = (1+5)/2 = 3.0
综合总分均分 = 5.0 + 4.0 + 3.0 = 12.0
```

---

### 【Step 3】汇总报告

当主持人说"查看汇总"、"生成报告"、"计算总分"时：

**执行：**

1. 用 `feishu_bitable_list_records` 读取表2所有打分记录
2. 按议题分组，重新计算每个议题的：
   - 维度一均分 = Σ维度一分 / 已打分评委人数
   - 维度二均分 = Σ维度二分 / 已打分评委人数
   - 维度三均分 = Σ维度三分 / 已打分评委人数
   - 综合总分均分 = 三维度均分之和（满分15分）
3. 用 `feishu_bitable_update_record` 将均分写回表1对应议题行
4. 将已全部打分的议题状态更新为「已完成」
5. 按综合总分均分从高到低排序，输出报告：

```
📊 议题评分汇总报告

排名  议题名称       维度一  维度二  维度三  综合均分
1.   XXX议题        4.5    4.0    3.5     12.0 ★
2.   YYY议题        3.5    4.0    4.0     11.5
3.   ZZZ议题        3.0    3.5    3.0      9.5

（维度名称以实际设定为准）
评委参与情况：{已打分人数}/{总评委人数}
{如有评委未完成打分，列出名单}

⚠️ 注：均分基于已提交打分计算
```

---

## 触发关键词

- 主持人初始化：「创建评分表」「新建议题评分」「开始评分」
- 评委打分：「我要打分」「提交评分」「给XXX议题打分」
- 启动自动计算：「开始自动计算」「监听打分」「自动更新总分」
- 查看汇总：「查看汇总」「生成报告」「评分结果」「各议题得分」
- 停止自动计算：「停止监听」「停止自动计算」

---

## 【Step 4】自动轮询计算总分（定时任务）

### 背景说明

飞书多维表格不支持 Webhook 触发，无法在评委填写后实时感知变化。
因此采用**定时轮询**方案：每隔固定间隔读取评分记录，自动计算并更新小计和均分。

### 启动方式

当主持人说「开始自动计算」或「监听打分」时，使用 `cron` 工具创建定时任务：

```
任务名：meeting-score-{app_token}-计算
调度：每0.5分钟执行一次（everyMs: 30000）
目标：isolated session
```

任务内容（agentTurn message 模板）：

```
请执行 meeting-score skill 的自动计算步骤：

多维表格 app_token: {app_token}
评分记录表 table_id: {score_table_id}
议题列表表 table_id: {agenda_table_id}
打分维度字段名: [{维度一字段名}, {维度二字段名}, {维度三字段名}]
分值映射: H（5分）=5, M（3分）=3, L（1分）=1

执行步骤：
1. 用 feishu_bitable_list_records 读取评分记录表所有记录
2. 对每条三个维度均已填写（非空）且小计为空或打分时间为空的记录：
   - 计算小计 = 维度一分值 + 维度二分值 + 维度三分值
   - 用 feishu_bitable_update_record 写回小计和打分时间（当前时间戳）
3. 按议题名称分组，计算各议题三个维度均分和综合总分均分（保留1位小数）
4. 用 feishu_bitable_update_record 将均分写回议题列表表对应行
5. 若某议题全部评委均已打分，将该议题状态更新为「已完成」
6. 若所有议题状态均为「已完成」，通过飞书发送消息给主持人：
   「📊 所有议题评分已完成！请说"查看汇总"获取完整报告。」
```

### 停止方式

当主持人说「停止自动计算」时，用 `cron` 工具禁用对应任务（enabled: false）。

### 重要提示

- 启动自动计算后，将任务 jobId 记录下来，用于后续停止
- 建议会议结束后手动停止自动计算，避免资源浪费
- 若评委通过对话方式打分（非直接填表），Step 2.5 会立即计算，无需等待轮询

---

## 注意事项

- **行级权限隔离**：「评分记录」表需主持人手动开启高级权限，确保每位评委只能看到自己的打分行（见 Step 1 第5步）
- 评委只应看到自己的打分行，不应主动展示其他评委的打分明细
- 如评委重复打分，覆盖之前的记录（以最新一次为准）
- 均分保留1位小数
- 主持人可随时查看汇总（即使未全部完成，标注参与人数即可）
- 多维表格创建后，将链接分享给主持人和所有评委
- 评委姓名需与其飞书账号显示名称保持一致，以确保高级权限规则正确生效
