# Meditation Topics by Profile

## Entrepreneur Profile

| Topic | What to Observe | Example Insight |
|-------|-----------------|-----------------|
| Project priorities | Which projects get most attention | "Project X hasn't been mentioned in 2 weeks — still priority?" |
| Bottlenecks | Repeated blockers in conversations | "You've mentioned waiting for Y three times — worth addressing?" |
| Strategy gaps | Goals vs actions mismatch | "Goal was Z but recent work focused elsewhere — intentional?" |
| Time patterns | When user is most productive | "Most complex discussions happen mornings — protected time?" |

## Developer Profile

| Topic | What to Observe | Example Insight |
|-------|-----------------|-----------------|
| Architecture | Repeated patterns or anti-patterns | "This pattern appears in 3 projects — worth abstracting?" |
| Tech debt | Mentioned but not addressed | "That refactor was mentioned twice — blocking anything?" |
| Tool usage | Inefficient workflows | "Manual step appears frequently — automation opportunity?" |
| Learning gaps | Errors or confusion patterns | "This error type recurs — documentation gap?" |

## Creative Profile

| Topic | What to Observe | Example Insight |
|-------|-----------------|-----------------|
| Prompt evolution | What works vs doesn't | "Style X consistently gets good results — worth documenting?" |
| Tool patterns | Which tools for which tasks | "Tool Y only used for Z — intentional limitation?" |
| Style drift | Changes over time | "Recent work more minimal — deliberate shift?" |
| Feedback patterns | What user accepts/rejects | "You often reject A but like B — preference to note?" |

## Personal Profile

| Topic | What to Observe | Example Insight |
|-------|-----------------|-----------------|
| Goal tracking | Mentioned vs followed up | "That habit goal from last month — still active?" |
| Calendar patterns | Scheduling vs actual | "Mornings often blocked but used for X — intentional?" |
| Relationship mentions | People referenced often | "Haven't mentioned X in a while — check-in needed?" |
| Wellbeing signals | Stress or energy indicators | "Last few days seemed intense — rest planned?" |

## System Profile

| Topic | What to Observe | Example Insight |
|-------|-----------------|-----------------|
| Configuration drift | Settings that changed | "This setting differs from baseline — intentional?" |
| Workflow gaps | Manual steps in automation | "This step still manual — worth automating?" |
| Error patterns | Recurring issues | "This error appeared 3 times — root cause?" |
| Resource usage | Efficiency opportunities | "Process X runs often — optimization candidate?" |

---

## Topic Discovery

When profile unknown or multi-faceted:
1. Start with generic observations about recent conversations
2. Note which topics get positive feedback
3. Gradually specialize based on user responses
4. Allow multiple profiles to coexist (entrepreneur + developer)
