# Media Digest Email Template

HTML email format optimized for Gmail/Outlook rendering.

## Delivery

**Step 1: Sanitize** — convert markdown report to XSS-safe HTML:
```bash
python3 <SKILL_DIR>/scripts/sanitize-html.py --input /tmp/md-report.md --output /tmp/md-email.html
```

**Step 2: Send** via `gog gmail send`:
```bash
gog gmail send --to '<EMAIL>' --subject '<SUBJECT>' --body-html "$(cat /tmp/md-email.html)"
```

⚠️ **Security**: Never manually build HTML from fetched content. Always use sanitize-html.py which HTML-escapes all text, validates URLs (http/https only), and strips dangerous content.

## Template Structure

```html
<div style="max-width:640px;margin:0 auto;font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;color:#1a1a1a;line-height:1.6">

  <h1 style="font-size:22px;border-bottom:2px solid #e5e5e5;padding-bottom:8px">
    🎬 每日影视日报 — {{DATE}}
  </h1>

  <p style="color:#555;font-size:14px;background:#f8f9fa;padding:12px;border-radius:6px">
    {{EXECUTIVE_SUMMARY}}
  </p>

  <h2 style="font-size:17px;margin-top:24px;color:#333">{{emoji}} {{label}}</h2>
  <ul style="padding-left:20px">
    <li style="margin-bottom:10px">
      <strong>🔥{{quality_score}} | {{chinese_summary}}</strong> — {{description}}
      <br><a href="{{link}}" style="color:#0969da;font-size:13px">{{link}}</a>
    </li>
  </ul>

  <h2 style="font-size:17px;margin-top:24px;color:#333">📢 KOL Updates</h2>
  <ul style="padding-left:20px">
    <li style="margin-bottom:10px">
      <strong>{{display_name}}</strong> (@{{handle}}) — {{summary}}
      <br><code style="font-size:12px;color:#888;background:#f4f4f4;padding:2px 6px;border-radius:3px">👁 {{views}} | 💬 {{replies}} | 🔁 {{retweets}} | ❤️ {{likes}}</code>
      <br><a href="{{tweet_link}}" style="color:#0969da;font-size:13px">{{tweet_link}}</a>
    </li>
  </ul>

  <hr style="border:none;border-top:1px solid #e5e5e5;margin:24px 0">
  <p style="font-size:12px;color:#888">
    📊 Data Sources: RSS {{rss_count}} | Twitter {{twitter_count}} | Web {{web_count}} | After dedup: {{merged_count}} articles
    <br>🤖 Generated by <a href="https://github.com/draco-agent/media-news-digest" style="color:#0969da">media-news-digest</a> v{{version}} | Powered by <a href="https://openclaw.ai" style="color:#0969da">OpenClaw</a>
  </p>

</div>
```

## Style Guidelines

- **Max width**: 640px centered (mobile-friendly)
- **Fonts**: System font stack (no web fonts in email)
- **All styles inline**: Email clients strip `<style>` tags
- **Links**: Use full URLs, styled with `color:#0969da`
- **Headings**: h1 for title (22px), h2 for topics (17px)
- **Lists**: `<ul>` with `<li>`, adequate spacing
- **Footer**: Small gray text with stats + repo link + OpenClaw branding
- **No images**: Pure text/HTML for maximum compatibility
- **No tables for layout**: Use div + inline styles
- **Chinese body + English links**
