# Media Digest Discord Template

Discord-optimized format with bullet points and link suppression.

## Template Structure

```markdown
# 🎬 每日影视日报 — {{DATE}}

> {{EXECUTIVE_SUMMARY}}

{{#topics}}
## {{emoji}} {{label}}

{{#articles}}
• 🔥{{quality_score}} | {{chinese_summary}}
  <{{link}}>
  {{#multi_source}}*[{{source_count}} sources]*{{/multi_source}}

{{/articles}}
{{/topics}}

## 📢 KOL Updates

{{#kol_tweets}}
• **{{display_name}}** (@{{handle}}) — {{summary}} `👁 {{views}} | 💬 {{replies}} | 🔁 {{retweets}} | ❤️ {{likes}}`
  <{{tweet_link}}>
{{/kol_tweets}}

## 📝 Deep Reads

{{#deep_reads}}
• {{title}} — {{description}}
  <{{link}}>
{{/deep_reads}}

---
📊 Data Sources: RSS {{rss_count}} | Twitter {{twitter_count}} | Web {{web_count}} | After dedup: {{merged_count}} articles
🤖 Generated by media-news-digest v{{version}} | <https://github.com/draco-agent/media-news-digest> | Powered by OpenClaw
```

## Delivery

- **Default: Channel** — Send to the Discord channel specified by `DISCORD_CHANNEL_ID`
- Use `message` tool with `target` set to the channel ID for channel delivery
- For DM delivery instead, set `target` to a user ID

## Discord-Specific Rules

- **Link suppression**: Wrap links in `<>` to prevent embeds
- **Bullet format**: Use `•` for clean mobile display
- **No tables**: Discord mobile doesn't handle markdown tables well
- **Emoji headers**: Visual hierarchy with topic emojis
- **Character limits**: Discord messages have 2000 char limit, may need splitting
- **Chinese body + English links**: Summary in Chinese, original links preserved
