---
name: meal-suggester
description: Quick dinner companion blending taste profiles, inventory tracking, and learning-based recipe rotation. Use to generate ≤25‑minute meals, log ingredients, and build shopping suggestions that respect both your and your partner’s preferences.
---

# Meal Suggester Skill

Suggest quick dinner recipes (≤25 min) tailored to your household's tastes and available ingredients.

## Features

- **Daily suggestions at 19:00** via cron job
- **Taste profiles** for you and your partner (preferences, dislikes, dietary needs)
- **Ingredient inventory** — markdown-based kitchen stock tracker
- **Learning system** — feedback improves future suggestions
- **Recipe matching** — respects time, tastes, and available ingredients
- **Ingredient tracking** — logs what you use to build a shopping list
- **Variety** — 15+ recipes that rotate, no monotony

## Files

- `SKILL.md` — this file
- `README.md` — setup & usage
- `preferences/user1.md` — first person's taste profile
- `preferences/user2.md` — second person's taste profile
- `inventory/stock.md` — current kitchen ingredients
- `inventory/history.md` — past suggestions & feedback
- `inventory/shopping-list.md` — suggested shopping list based on usage patterns
- `scripts/suggest-meal.sh` — main suggestion script

## Usage

### Get a suggestion
```bash
clawdbot skill run meal-suggester
```

### Log ingredients used
After cooking, just tell me: "on a utilisé lardons, pois chiches, une carotte"
I'll automatically update `stock.md` and track what needs reordering.

### Update inventory
Add items to `inventory/stock.md` with quantities and categories.

### Provide feedback
Edit `inventory/history.md` with what you cooked + feedback (liked/disliked/would-repeat).

### View shopping suggestions
Check `inventory/shopping-list.md` for items that are running low or needed.

### View profiles
Check `preferences/user1.md` and `preferences/user2.md` to see what the system knows about each user.

## How It Works

1. **Reads current inventory** from `inventory/stock.md`
2. **Checks preferences** from both taste profiles
3. **Tracks usage** — you tell me what you used, I update stock
4. **Suggests shopping** — when stock runs low, I build a shopping list
5. **Generates recipe** that:
   - Uses ingredients you have on hand
   - Respects both people's preferences
   - Takes ≤25 minutes
   - Avoids dislikes
   - Rotates through variety (15+ recipes)
6. **Logs suggestion** to history for learning

## Cron Schedule

Daily at 19:00 (7 PM) — a reminder with a recipe idea lands in your chat.

## Feedback Loop

- Try the recipe → tell me what you think + what you used
- System learns from "I loved this" / "too spicy" / "we'd make this again"
- Stock updates automatically
- Shopping list builds itself
- Next suggestions get smarter

---

*A kitchen memory that learns and never gets boring.*

