# Shopping Guide — Meal Planner

## Shopping List Principles

### 1. Link Items to Meals
Never create orphan items. Every item should trace back to a specific meal:
```
- [ ] Chicken breast (2 lb) — Mon stir-fry, Thu tacos
```
This helps users understand why they're buying things and reduces waste.

### 2. Check Inventory First
Before adding to list:
1. Read `inventory/pantry.md` and `inventory/fridge.md`
2. Only add items marked "low" or "out"
3. Note: "assuming you have olive oil" for common staples

### 3. Organize by Store Section
Standard order (adjust to user's store layout):
```markdown
## Shopping List — YYYY-MM-DD

### Produce
- [ ] Items

### Meat & Seafood
- [ ] Items

### Dairy & Eggs
- [ ] Items

### Bakery
- [ ] Items

### Pantry / Dry Goods
- [ ] Items (only if low)

### Frozen
- [ ] Items

### Other
- [ ] Items
```

## Quantity Guidelines

### Proteins
| Protein | Per Adult | Per Child | Notes |
|---------|-----------|-----------|-------|
| Chicken breast | 6-8 oz | 3-4 oz | Boneless |
| Ground meat | 4-6 oz | 2-3 oz | For burgers/tacos |
| Fish fillet | 6 oz | 3 oz | Adjust for bones |
| Tofu | 4-6 oz | 2-3 oz | Firm for cooking |

### Vegetables
| Use | Amount per person |
|-----|-------------------|
| Main component | 1 cup raw |
| Side dish | 0.5-1 cup |
| Salad base | 2 cups greens |
| Stir-fry mix | 1.5 cups |

### Grains
| Grain | Dry amount per person | Cooked yield |
|-------|----------------------|--------------|
| Rice | 0.5 cup | 1.5 cups |
| Pasta | 2-3 oz dry | 1 cup cooked |
| Quinoa | 0.33 cup | 1 cup cooked |

## Cost Optimization

### Seasonal Produce
Buying in season saves 20-40%:

**Spring:** Asparagus, peas, artichokes, strawberries
**Summer:** Tomatoes, zucchini, corn, berries, peaches
**Fall:** Apples, squash, pumpkin, Brussels sprouts
**Winter:** Citrus, root vegetables, cabbage, kale

### Protein Rotation Strategy
Balance cost across the week:
| Day | Protein Type | Cost Level |
|-----|--------------|------------|
| Mon | Chicken | $$ |
| Tue | Beans/lentils | $ |
| Wed | Eggs | $ |
| Thu | Pork | $$ |
| Fri | Fish | $$$ |
| Sat | Beef | $$$ |
| Sun | Leftovers | $ |

### Store Brand Strategy
Items where store brand = national brand quality:
- Canned tomatoes, beans
- Flour, sugar, salt
- Frozen vegetables
- Milk, butter
- Pasta, rice

Stick with brands for:
- Items where taste matters to user
- Specialty items

## Shopping Timing

### Optimal Days
- **Best:** Tuesday, Wednesday (restocked, less crowded)
- **Worst:** Sunday afternoon, Saturday morning
- **For deals:** Check store's sale cycle (often starts Wednesday or Sunday)

### Freshness Planning
| Category | Buy | Use within |
|----------|-----|------------|
| Leafy greens | 3-4 days before use | 4-5 days |
| Berries | 2-3 days before use | 3-4 days |
| Meat | Day of or 1-2 days before | Cook or freeze |
| Fish | Day of use | Same day best |
| Root vegetables | Anytime | 2+ weeks |

## List Generation Checklist

Before finalizing any shopping list:
- [ ] All items linked to specific meals
- [ ] Inventory checked for duplicates
- [ ] Quantities appropriate for household size
- [ ] Budget estimate included
- [ ] Organized by store section
- [ ] Any substitution notes (if item unavailable)
