# Meal Prep Guide — Meal Planner

## Batch Cooking Philosophy

**Goal:** Reduce daily cooking burden while keeping meals feeling fresh.

**The rule:** Cook components, not complete meals.
- Complete meals get boring by day 3
- Components can remix into different dishes

## Weekly Prep Session

### Suggested Timing
| Prep Type | Best Time | Duration |
|-----------|-----------|----------|
| Full week prep | Sunday afternoon | 2-3 hours |
| Mid-week refresh | Wednesday evening | 30-45 min |
| Light prep | Morning before work | 15-20 min |

### Sunday Prep Checklist
```markdown
## Prep List — Week of YYYY-MM-DD

### Grains (20 min)
- [ ] Cook rice (4 cups dry) — use for Mon, Tue, Wed
- [ ] Cook quinoa (2 cups dry) — Thu, Fri lunches

### Proteins (30-45 min)
- [ ] Bake chicken breasts (2 lb) — Mon salad, Wed tacos
- [ ] Brown ground beef (1.5 lb) — Tue pasta, Thu bowls
- [ ] Hard boil eggs (12) — snacks, quick breakfasts

### Vegetables (30 min)
- [ ] Wash and chop salad greens — portion into containers
- [ ] Roast mixed vegetables — side dishes for week
- [ ] Cut stir-fry vegetables — bag for quick cooking

### Sauces & Bases (15 min)
- [ ] Make vinaigrette — salads all week
- [ ] Prep marinade for Thu fish

### Storage
| Prep Item | Container | Fridge Life |
|-----------|-----------|-------------|
| Cooked grains | Airtight | 4-5 days |
| Cooked proteins | Glass containers | 3-4 days |
| Cut raw vegetables | Paper towel lined | 4-5 days |
| Washed greens | Salad spinner | 5-7 days |
```

## Component-Based Meal System

### Grain + Protein + Vegetable + Sauce
Prep these separately, combine differently each day:

**Grains (pick 2):**
- Rice, quinoa, pasta, couscous, farro

**Proteins (pick 3):**
- Grilled chicken, baked tofu, hard-boiled eggs, beans, pulled pork

**Vegetables (pick 4-5):**
- Roasted (broccoli, sweet potato, Brussels)
- Raw (cucumbers, tomatoes, carrots)
- Sauteed base (onions, peppers, garlic)

**Sauces (pick 2-3):**
- Vinaigrette, tahini dressing, teriyaki, peanut sauce

### Example Combinations
| Day | Base | Protein | Veg | Sauce | Result |
|-----|------|---------|-----|-------|--------|
| Mon | Rice | Chicken | Roasted broccoli | Teriyaki | Asian bowl |
| Tue | Rice | Chicken | Raw veg | Peanut | Thai salad |
| Wed | Quinoa | Eggs | Roasted sweet potato | Tahini | Mediterranean bowl |
| Thu | Quinoa | Beans | Tomatoes, corn | Lime vinaigrette | Mexican bowl |

## Make-Ahead Meals

### Fully Prepared (freezer-friendly)
| Meal | Prep | Storage | Reheat |
|------|------|---------|--------|
| Soups | Full cook | 3 months freezer | Stovetop or microwave |
| Chili | Full cook | 3 months freezer | Stovetop |
| Casseroles | Assemble, don't bake | 1 month freezer | Bake from frozen +15 min |
| Meatballs | Shape and freeze | 3 months | Cook from frozen |
| Burritos | Wrap in foil | 1 month freezer | Oven 375F 20 min |

### Partial Prep (speed up weeknight cooking)
| Prep | Do Ahead | Day-of |
|------|----------|--------|
| Stir-fry | Cut vegetables, mix sauce | Cook 10 min |
| Tacos | Cook protein, prep toppings | Assemble 5 min |
| Pasta | Make sauce | Boil pasta, combine |
| Sheet pan meals | Cut vegetables, marinate protein | Roast 25-30 min |

## Time-Saving Techniques

### Multitasking Setup
While one thing cooks, start the next:
1. Start water boiling for grains
2. While waiting, season proteins
3. Put proteins in oven
4. Add grains to boiling water
5. While those cook, prep vegetables
6. Roast vegetables when protein comes out

### Efficient Chopping Order
Prep in this sequence (avoids cross-contamination, minimizes board washing):
1. Herbs and aromatics (garlic, onions, herbs)
2. Vegetables
3. Fruits
4. Raw proteins (always last)

### Container Strategy
| Container Type | Best For |
|----------------|----------|
| Glass with lids | Cooked proteins, sauces (microwave safe) |
| Plastic containers | Prepped vegetables |
| Mason jars | Salad dressings, overnight oats |
| Zip bags | Marinating proteins, freezer storage |
| Silicone bags | Reusable for snacks, sous vide |

## Energy Level Planning

Match meal complexity to predicted energy:
| Day | Typical Energy | Meal Strategy |
|-----|----------------|---------------|
| Monday | Medium (weekend recovery) | Prepped components, easy assembly |
| Tuesday | High | Can handle more cooking |
| Wednesday | Medium | Use prepped items |
| Thursday | Declining | Quick or pre-made |
| Friday | Low | Leftovers, takeout backup, or 15-min meals |
| Weekend | Variable | Fresh cooking or batch prep |

## Leftovers Strategy

### Intentional Leftovers
Cook extra on purpose:
- Roast a whole chicken Sunday → sandwiches Monday, soup Tuesday
- Double pasta sauce → freeze half
- Extra rice → fried rice in 2-3 days

### Leftover Transformation
| Original | Day 2 Transformation | Day 3+ |
|----------|---------------------|--------|
| Roast chicken | Chicken salad | Chicken soup |
| Grilled steak | Steak tacos | Beef fried rice |
| Roasted vegetables | Frittata filling | Soup addition |
| Plain rice | Fried rice | Rice pudding |

### Safety Guidelines
| Food Type | Safe Refrigerator Time | Signs to Discard |
|-----------|----------------------|------------------|
| Cooked proteins | 3-4 days | Smell, slime, color change |
| Cooked grains | 4-5 days | Mold, sour smell |
| Cut vegetables | 4-5 days | Wilting, slime |
| Soups/stews | 3-4 days | Bubbling, off smell |
