# Budget Tips — Meal Planner

## Weekly Budget Benchmarks

### Per-Person Weekly Ranges (US, 2024-2026)
| Budget Level | Weekly Per Person | Monthly Per Person |
|--------------|-------------------|-------------------|
| Thrifty | $50-65 | $200-260 |
| Moderate | $65-90 | $260-360 |
| Liberal | $90-120 | $360-480 |
| Flexible | $120+ | $480+ |

Adjust for location (cities +20-40%) and dietary restrictions (+10-30%).

### Family Multipliers
| Household | Multiplier | Notes |
|-----------|------------|-------|
| 1 adult | 1.0x | Base rate |
| 2 adults | 1.8x | Slight efficiency |
| 2 adults + 1 child | 2.3x | Kids eat less |
| 2 adults + 2 children | 2.8x | Bulk buying helps |
| 4+ people | 3.2x+ | Significant bulk savings |

## Cost-Cutting Strategies

### Tier 1: Easy Wins (No lifestyle change)

| Strategy | Savings | Implementation |
|----------|---------|----------------|
| Store brands | 10-30% | Switch staples first |
| Shopping list only | 15-20% | Avoid impulse buys |
| Seasonal produce | 20-40% | Follow what's fresh |
| Unit price comparison | 5-15% | Bigger isn't always cheaper |
| Sales cycle awareness | 10-20% | Stock up during deals |

### Tier 2: Moderate Effort (Some planning)

| Strategy | Savings | Implementation |
|----------|---------|----------------|
| Meal planning | 15-25% | Plan before shopping |
| Batch cooking | 10-20% | Prep on weekends |
| Meatless days | 15-30% | 2-3 days per week |
| Leftover transformation | 10-15% | Plan second-day meals |
| Freezer inventory | 10-15% | Use what you have |

### Tier 3: Higher Effort (Significant changes)

| Strategy | Savings | Implementation |
|----------|---------|----------------|
| Pantry-first meals | 20-40% | Build from what's on hand |
| Whole ingredients | 15-25% | Cut your own vegetables |
| Multiple stores | 10-20% | Loss leaders at each |
| Bulk buying | 15-30% | For frequently used items |
| Garden growing | Variable | Herbs, tomatoes, greens |

## Protein Cost Hierarchy

| Protein | Cost per serving | Protein per serving | Cost efficiency |
|---------|------------------|---------------------|-----------------|
| Dried beans/lentils | $0.15-0.30 | 15g | Excellent |
| Eggs | $0.25-0.50 | 12g | Excellent |
| Canned beans | $0.30-0.50 | 12g | Very good |
| Chicken thighs | $0.80-1.50 | 25g | Very good |
| Tofu | $0.60-1.00 | 15g | Good |
| Ground beef | $1.00-2.00 | 22g | Moderate |
| Chicken breast | $1.50-2.50 | 30g | Moderate |
| Pork chops | $1.50-2.50 | 25g | Moderate |
| Fish (tilapia, etc) | $1.50-3.00 | 22g | Moderate |
| Beef steak | $3.00-6.00 | 25g | Low |
| Salmon | $3.00-5.00 | 25g | Low |
| Shrimp | $3.00-5.00 | 20g | Low |

## Pantry-First Meal Planning

### The "Pantry Challenge" Approach
Before shopping, ask: "What can I make with what I already have?"

**Core pantry staples (keep stocked):**
- Rice, pasta, oats
- Canned beans, tomatoes, coconut milk
- Olive oil, vegetable oil
- Flour, sugar
- Salt, pepper, basic spices
- Soy sauce, vinegar
- Onions, garlic
- Potatoes

**From pantry staples alone:**
- Pasta with garlic and oil
- Bean soup
- Fried rice (if eggs/vegetables available)
- Oatmeal
- Potato dishes
- Rice and beans

### End-of-Budget Meals
When groceries run low but payday is coming:
| Meal | Main Ingredients | Cost Estimate |
|------|------------------|---------------|
| Egg fried rice | Rice, eggs, soy sauce | $1-2 |
| Bean burritos | Beans, rice, tortillas | $1-2 |
| Pasta aglio e olio | Pasta, garlic, oil, parmesan | $1-2 |
| Potato hash | Potatoes, onions, eggs | $1-2 |
| Lentil soup | Lentils, canned tomatoes, spices | $1-2 |
| Oatmeal variations | Oats, whatever fruit/nuts | $0.50-1 |

## Budget Tracking

### Weekly Log Format
```markdown
## Food Budget — Week of YYYY-MM-DD

### Target: $XXX

### Actual Spending
| Date | Store | Planned | Actual | Notes |
|------|-------|---------|--------|-------|
| Mon | Store A | $50 | $62 | Stocked up olive oil |
| Wed | Store B | $30 | $28 | Under budget |

**Total:** $XX / $XXX target
**Variance:** +$XX over / -$XX under

### Analysis
- What went over: [category]
- What saved money: [strategy]
- Adjustment for next week: [plan]
```

### Monthly Review Questions
1. Which meals had best cost-to-satisfaction ratio?
2. What did we buy that went to waste?
3. What impulse buys could have been avoided?
4. Which store had best prices for our staples?
5. Did meatless days feel sustainable?

## Reducing Food Waste

Food waste = money in the garbage.

### Prevention Strategies
| Issue | Prevention |
|-------|------------|
| Overbuying produce | Buy for 3-4 days, not 7 |
| Forgotten leftovers | "Leftover night" every 3-4 days |
| Impulse fresh items | Only buy with plan to use |
| Expired pantry items | Rotate stock (FIFO) |
| Too much variety | Fewer recipes, larger portions |

### Save-It Meals
When things are about to go bad:
- Wilting greens → smoothie, soup, or saute
- Soft fruit → freeze for smoothies, bake into something
- Stale bread → breadcrumbs, croutons, bread pudding
- Aging vegetables → roast all together, make stock
- Almost-bad meat → cook immediately, freeze cooked

### Freezer as Money Saver
Items to freeze before they go bad:
- Bread (slice first)
- Ripe bananas (peeled)
- Fresh herbs (in olive oil cubes)
- Ginger (grate from frozen)
- Meat (portion before freezing)
- Leftover wine (for cooking)
