---
name: mcporter-railway-query
description: Query and book Chinese railway tickets via 12306 using mcporter CLI. Use when user wants to search for G/D/C train tickets, check train schedules, query seat availability, or plan rail travel between Chinese cities. Supports filtering by date, time range, train type, and sorting results.
---

# mcporter Railway Ticket Query

使用 mcporter 命令行工具查询 12306 中国铁路车票信息。

## Prerequisites

1. 安装 mcporter CLI
2. 配置 12306 MCP 服务器
3. 确认 mcporter.json 配置路径（默认 ~/.mcporter/mcporter.json）

## Quick Start

### 1. 使用快捷脚本查询

```bash
# 查询下午班次 (12:00-18:00)
./scripts/query-afternoon.sh 2026-02-18 SHH KYH

# 查询全天班次
./scripts/query-tickets.sh 2026-02-18 AOH HZH

# 查询车站代码
./scripts/get-station-code.sh "上海虹桥"
```

### 2. 直接 mcporter 命令

```bash
# 基础查询
mcporter call 12306.get-tickets \
  date="2026-02-18" \
  fromStation="AOH" \
  toStation="HZH" \
  trainFilterFlags="GD" \
  --config ~/.mcporter/mcporter.json

# 下午班次
mcporter call 12306.get-tickets \
  date="2026-02-18" \
  fromStation="AOH" \
  toStation="HZH" \
  trainFilterFlags="GD" \
  earliestStartTime=12 \
  latestStartTime=18 \
  sortFlag="startTime" \
  --config ~/.mcporter/mcporter.json
```

## Workflow

### Step 1: 获取车站代码

不知道车站代码时：

```bash
mcporter call 12306.get-station-code-of-citys \
  citys="上海|杭州" \
  --config ~/.mcporter/mcporter.json
```

或查看参考表 [station-codes.md](references/station-codes.md)

### Step 2: 查询车票

```bash
mcporter call 12306.get-tickets \
  date="YYYY-MM-DD" \
  fromStation="出发站代码" \
  toStation="到达站代码" \
  [可选过滤参数] \
  --config ~/.mcporter/mcporter.json
```

### Step 3: 解析结果

- 有票: "**有票**" 或显示剩余票数 "剩余X张票"
- 无票: "无票"
- *票: 特殊标记票

## Parameters Reference

| 参数 | 类型 | 默认值 | 说明 |
|------|------|--------|------|
| date | string | 必填 | 日期格式 YYYY-MM-DD |
| fromStation | string | 必填 | 出发站代码 (如 SHH) |
| toStation | string | 必填 | 到达站代码 (如 KYH) |
| trainFilterFlags | string | "" | G=高铁, D=动车, GD=高铁+动车 |
| earliestStartTime | number | 0 | 最早出发时间 (0-24) |
| latestStartTime | number | 24 | 最晚出发时间 (0-24) |
| sortFlag | string | "" | startTime/arriveTime/duration |
| sortReverse | boolean | false | 是否倒序 |
| limitedNum | number | 0 | 限制结果数量 |
| format | string | text | text/json/csv |

## Common Station Codes

| 城市 | 代码 | 城市 | 代码 |
|------|------|------|------|
| 上海 | SHH | 上海虹桥 | AOH |
| 杭州东 | HZH | 无锡 | WXH |
| 江阴 | KYH | 南京南 | NKH |

完整列表见 [station-codes.md](references/station-codes.md)

## Troubleshooting

### mcporter not found
```bash
npm install -g mcporter
```

### 12306 MCP 未配置
创建 ~/.mcporter/mcporter.json 配置文件。

### 查询无结果
- 确认车站代码正确
- 确认日期格式为 YYYY-MM-DD
- 检查 mcporter.json 路径

## Examples

更多查询示例见 [query-examples.md](references/query-examples.md)