# Usage Examples

Practical examples of using the MCP Integration plugin with OpenClaw.

## 📚 Table of Contents

1. [Basic Usage](#basic-usage)
2. [Legal Research](#legal-research)
3. [Database Queries](#database-queries)
4. [Weather Service](#weather-service)
5. [Multi-Step Workflows](#multi-step-workflows)
6. [Error Handling](#error-handling)

## 🎯 Basic Usage

### Example 1: List All Available Tools

**User:** "What MCP tools do I have access to?"

**OpenClaw Agent:**
```
I'll check what MCP tools are available.

[Tool: mcp]
Action: list
```

**Tool Call:**
```json
{
  "tool": "mcp",
  "args": {
    "action": "list"
  }
}
```

**Agent Response:**
```
Available MCP tools:

Legal Services (kr-legal):
• search_statute - Search Korean statutes and regulations
• search_case_law - Search court decisions and precedents
• resolve_citation - Resolve legal citations to full text

Database (database):
• query - Execute SQL queries
• schema - Get database schema

Weather (weather):
• get_forecast - Get weather forecast
• get_current - Get current weather conditions
```

### Example 2: Call a Simple Tool

**User:** "Get the weather for Seoul"

**OpenClaw Agent:**
```
I'll check the weather in Seoul.

[Tool: mcp]
Action: call
Server: weather
Tool: get_current
Arguments: {city: "Seoul"}
```

**Tool Call:**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "weather",
    "tool": "get_current",
    "args": {
      "city": "Seoul"
    }
  }
}
```

**Agent Response:**
```
Current weather in Seoul:
• Temperature: 15°C
• Conditions: Partly cloudy
• Humidity: 65%
• Wind: 12 km/h NW
```

## ⚖️ Legal Research

### Example 3: Search Korean Statutes

**User:** "Find Korean laws about unfair dismissal"

**Agent Workflow:**
```
I'll search Korean legal statutes for unfair dismissal.

[Tool: mcp]
Action: call
Server: kr-legal
Tool: search_statute
Arguments: {query: "부당해고", category: "노동법", limit: 5}
```

**Tool Call:**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "kr-legal",
    "tool": "search_statute",
    "args": {
      "query": "부당해고",
      "category": "노동법",
      "limit": 5
    }
  }
}
```

**Agent Response:**
```
Found 5 statutes related to unfair dismissal:

1. 근로기준법 제23조 (해고 등의 제한)
   - Enacted: 1953-05-10
   - Last amended: 2023-01-01
   - Summary: 정당한 이유 없는 해고, 휴직, 정직 등을 금지

2. 근로기준법 제26조 (해고의 예고)
   - Summary: 해고 시 30일 전 예고 또는 30일분 통상임금 지급

3. 노동조합 및 노동관계조정법 제81조 (부당해고 등의 구제신청)
   - Summary: 부당해고 등의 경우 노동위원회에 구제 신청 가능

Would you like me to get the full text of any of these statutes?
```

### Example 4: Get Full Statute Text

**User:** "Yes, show me the full text of 근로기준법 제23조"

**Agent Workflow:**
```
I'll retrieve the full text of 근로기준법 제23조.

[Tool: mcp]
Action: call
Server: kr-legal
Tool: get_statute_full_text
Arguments: {statute_id: "0065", article: 23}
```

**Tool Call:**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "kr-legal",
    "tool": "get_statute_full_text",
    "args": {
      "statute_id": "0065",
      "article": 23
    }
  }
}
```

**Agent Response:**
```
근로기준법 제23조 (해고 등의 제한)

① 사용자는 근로자에게 정당한 이유 없이 해고, 휴직, 정직, 전직, 감봉, 그 밖의 징벌을 하지 못한다.

② 사용자는 근로자가 업무상 부상 또는 질병의 요양을 위하여 휴업한 기간과 그 후 30일 동안 또는 산전·산후의 여성이 이 법에 따라 휴업한 기간과 그 후 30일 동안은 해고하지 못한다. 다만, 사용자가 제84조에 따라 일시보상을 하였을 경우 또는 사업을 계속할 수 없게 된 경우에는 그러하지 아니하다.

Related provisions:
• 제24조 (경영상 이유에 의한 해고의 제한)
• 제26조 (해고의 예고)
• 제27조 (해고사유 등의 서면통지)
```

### Example 5: Search Case Law

**User:** "Find Supreme Court cases about unfair dismissal from the last 3 years"

**Tool Call:**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "kr-legal",
    "tool": "search_case_law",
    "args": {
      "query": "부당해고",
      "court": "supreme",
      "date_from": "2021-01-01",
      "limit": 5
    }
  }
}
```

## 💾 Database Queries

### Example 6: Query Database

**User:** "Show me the latest 10 orders from the database"

**Tool Call:**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "database",
    "tool": "query",
    "args": {
      "sql": "SELECT * FROM orders ORDER BY created_at DESC LIMIT 10"
    }
  }
}
```

**Agent Response:**
```
Latest 10 orders:

| Order ID | Customer | Amount  | Status    | Date       |
|----------|----------|---------|-----------|------------|
| ORD-1234 | John Doe | $150.00 | Completed | 2026-02-01 |
| ORD-1233 | Jane Doe | $89.99  | Pending   | 2026-01-31 |
...
```

### Example 7: Get Database Schema

**User:** "What tables are in the database?"

**Tool Call:**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "database",
    "tool": "schema",
    "args": {}
  }
}
```

## 🌦️ Weather Service

### Example 8: Weather Forecast

**User:** "What's the 7-day forecast for Tokyo?"

**Tool Call:**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "weather",
    "tool": "get_forecast",
    "args": {
      "city": "Tokyo",
      "days": 7
    }
  }
}
```

**Agent Response:**
```
7-day forecast for Tokyo:

Mon Feb 3: ☀️ Sunny, 12°C / 5°C
Tue Feb 4: ⛅ Partly cloudy, 14°C / 7°C
Wed Feb 5: 🌧️ Rain, 11°C / 6°C
Thu Feb 6: ☁️ Cloudy, 10°C / 4°C
Fri Feb 7: ☀️ Sunny, 13°C / 5°C
Sat Feb 8: ⛅ Partly cloudy, 15°C / 8°C
Sun Feb 9: ☀️ Sunny, 16°C / 9°C
```

## 🔄 Multi-Step Workflows

### Example 9: Legal Research + Analysis

**User:** "Research Korean labor law about overtime pay and explain how it applies to my situation"

**Agent Workflow:**

**Step 1: Search statutes**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "kr-legal",
    "tool": "search_statute",
    "args": {
      "query": "연장근로 수당",
      "category": "노동법"
    }
  }
}
```

**Step 2: Get detailed analysis**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "kr-legal",
    "tool": "analyze_law",
    "args": {
      "statute_or_case": "근로기준법 제56조",
      "analysis_type": "practical",
      "context": "야간근무 및 연장근무 수당 계산"
    }
  }
}
```

**Step 3: Find related cases**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "kr-legal",
    "tool": "search_case_law",
    "args": {
      "query": "연장근무 수당",
      "court": "supreme",
      "limit": 3
    }
  }
}
```

**Agent Response:**
```
Korean Labor Law on Overtime Pay - Comprehensive Analysis

Legal Basis:
근로기준법 제56조 (연장·야간 및 휴일 근로)

Key Points:
1. Overtime (beyond 40 hrs/week): +50% premium
2. Night work (10PM-6AM): +50% premium
3. Holiday work: +50% premium
4. Overlapping premiums stack (e.g., night + overtime = +100%)

Your Situation:
[Analysis based on context provided...]

Relevant Precedents:
1. Supreme Court 2019다67890 - Overtime pay calculation
2. Supreme Court 2018da54321 - Night work premium requirements
3. Supreme Court 2020da12345 - Combined premium application

Next Steps:
[Actionable advice based on analysis...]
```

### Example 10: Database + Weather Integration

**User:** "Check if we have any outdoor events scheduled when it's going to rain"

**Step 1: Query events**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "database",
    "tool": "query",
    "args": {
      "sql": "SELECT event_name, location, event_date FROM events WHERE location_type = 'outdoor' AND event_date >= CURRENT_DATE ORDER BY event_date"
    }
  }
}
```

**Step 2: Check weather for each date**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "weather",
    "tool": "get_forecast",
    "args": {
      "city": "Seoul",
      "days": 14
    }
  }
}
```

**Agent Response:**
```
Outdoor Events with Rain Risk:

⚠️ Feb 5 - Company Picnic (Seoul Park)
   Forecast: 80% rain, 11°C
   Recommendation: Consider moving indoors or rescheduling

✅ Feb 7 - Team Building (Han River)
   Forecast: Sunny, 13°C
   Status: Good to proceed

⚠️ Feb 10 - Product Launch (Rooftop Venue)
   Forecast: 60% rain, 12°C
   Recommendation: Prepare backup indoor location
```

## ❌ Error Handling

### Example 11: Invalid Tool

**User:** "Use the magic tool"

**Tool Call:**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "kr-legal",
    "tool": "magic_tool",
    "args": {}
  }
}
```

**Response:**
```json
{
  "content": [
    {
      "type": "text",
      "text": "Error: Tool not found: kr-legal:magic_tool. Available: kr-legal:search_statute, kr-legal:search_case_law, kr-legal:resolve_citation, kr-legal:get_statute_full_text, kr-legal:analyze_law"
    }
  ],
  "isError": true
}
```

**Agent Response:**
```
I don't have access to a "magic tool" in the kr-legal server. 

Available legal tools are:
• search_statute - Search statutes
• search_case_law - Search case law
• resolve_citation - Resolve citations
• get_statute_full_text - Get full statute text
• analyze_law - Analyze laws

What would you like me to do?
```

### Example 12: Missing Required Parameter

**Tool Call:**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "kr-legal",
    "tool": "search_statute"
    // Missing "args" with required "query" parameter
  }
}
```

**Response:**
```json
{
  "content": [
    {
      "type": "text",
      "text": "Error: Invalid arguments for search_statute. Required: query"
    }
  ],
  "isError": true
}
```

### Example 13: Server Connection Error

**Tool Call:**
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "offline-server",
    "tool": "some_tool",
    "args": {}
  }
}
```

**Response:**
```json
{
  "content": [
    {
      "type": "text",
      "text": "Error: Tool not found: offline-server:some_tool. Server may be disconnected."
    }
  ],
  "isError": true
}
```

## 🔗 Related Documentation

- [Main README](../README.md)
- [API Reference](API.md)
- [Configuration Guide](CONFIGURATION.md)

---

**Tips for Using MCP Tools:**
- Always start with `action=list` to see available tools
- Check tool input schemas before calling
- Provide all required parameters
- Handle errors gracefully
- Chain multiple tools for complex workflows
