# Documentation Index

Complete index of all documentation for the MCP Integration plugin.

## 📚 Core Documentation

### ✅ [REAL_EXAMPLE_KR_LEGAL.md](REAL_EXAMPLE_KR_LEGAL.md) (5.2KB) ⭐ START HERE!
**Real working configuration** - kr-legal-search example (NO API KEY REQUIRED)
- Actual working setup
- Step-by-step verification
- Troubleshooting specific to kr-legal
- Complete test interaction examples

**This is the easiest way to see the plugin working!**

### 📖 [README.md](../README.md) (17KB)
**Main documentation** - Start here!
- Overview and features
- Installation instructions
- Basic configuration
- Usage guide
- Architecture diagrams
- Examples
- Security considerations
- FAQ

**Read this first** to understand what the plugin does and how to get started.

### ⚙️ [CONFIGURATION.md](CONFIGURATION.md) (6.8KB)
**Complete configuration guide**
- Configuration file structure
- All configuration options explained
- Environment variable management
- Per-agent configuration
- Multiple server setup
- Security best practices
- Validation and testing

**Use this** when setting up or modifying your plugin configuration.

### 🔧 [API.md](API.md) (8.3KB)
**API reference documentation**
- `mcp` tool specification
- `list` action reference
- `call` action reference
- MCPManager class API
- StreamableHTTPClientTransport API
- JSON-RPC protocol details
- Request/response formats

**Use this** when developing integrations or understanding the internal API.

### 💡 [EXAMPLES.md](EXAMPLES.md) (11KB)
**Practical usage examples**
- Basic usage (listing tools, calling tools)
- Legal research workflows
- Database queries
- Weather service integration
- Multi-step workflows
- Error handling examples

**Use this** to see real-world usage patterns and copy-paste examples.

### 🐛 [TROUBLESHOOTING.md](TROUBLESHOOTING.md) (9.2KB)
**Problem-solving guide**
- Common issues and solutions
- Diagnostic commands
- Debug mode setup
- Connection problems
- Configuration errors
- Tool call failures
- Creating diagnostic reports

**Use this** when something isn't working as expected.

### 🤝 [CONTRIBUTING.md](CONTRIBUTING.md) (7.0KB)
**Contributor guidelines**
- Development setup
- Code style guide
- Testing procedures
- Pull request process
- Bug reporting template
- Feature request template
- Code of conduct

**Use this** if you want to contribute to the plugin.

### 📝 [CHANGELOG.md](CHANGELOG.md) (2.5KB)
**Version history and changes**
- Release notes
- New features
- Bug fixes
- Breaking changes
- Migration guides

**Use this** to track what's changed between versions.

## 🗂️ Quick Reference

### By Use Case

**I want to...**

- **Get started quickly** → [README.md](../README.md)
- **Install the plugin** → [README.md#installation](../README.md#installation)
- **Configure servers** → [CONFIGURATION.md](CONFIGURATION.md)
- **See examples** → [EXAMPLES.md](EXAMPLES.md)
- **Fix a problem** → [TROUBLESHOOTING.md](TROUBLESHOOTING.md)
- **Understand the API** → [API.md](API.md)
- **Contribute code** → [CONTRIBUTING.md](CONTRIBUTING.md)
- **Check what changed** → [CHANGELOG.md](CHANGELOG.md)

### By Skill Level

**Beginner:**
1. Start with [README.md](../README.md)
2. Follow installation steps
3. Try [EXAMPLES.md](EXAMPLES.md) basic examples
4. If stuck, check [TROUBLESHOOTING.md](TROUBLESHOOTING.md)

**Intermediate:**
1. Review [CONFIGURATION.md](CONFIGURATION.md) for advanced setup
2. Study [EXAMPLES.md](EXAMPLES.md) for workflow patterns
3. Reference [API.md](API.md) for tool parameters

**Advanced:**
1. Deep dive into [API.md](API.md)
2. Review source code (`index.js`, `http-transport.js`)
3. Read [CONTRIBUTING.md](CONTRIBUTING.md) to contribute

## 📋 Documentation Statistics

| File | Size | Purpose |
|------|------|---------|
| README.md | 17KB | Main documentation |
| CONFIGURATION.md | 6.8KB | Configuration guide |
| API.md | 8.3KB | API reference |
| EXAMPLES.md | 11KB | Usage examples |
| TROUBLESHOOTING.md | 9.2KB | Problem solving |
| CONTRIBUTING.md | 7.0KB | Contributor guide |
| CHANGELOG.md | 2.5KB | Version history |
| **Total** | **61.8KB** | **7 documents** |

## 🔍 Search Guide

### Finding Information

**Configuration:**
- Server setup → [CONFIGURATION.md#basic-configuration](CONFIGURATION.md)
- Environment variables → [CONFIGURATION.md#environment-variables](CONFIGURATION.md)
- Multiple servers → [CONFIGURATION.md#multiple-server-configurations](CONFIGURATION.md)

**Usage:**
- List tools → [API.md#list-tools](API.md), [EXAMPLES.md#list-all-available-tools](EXAMPLES.md)
- Call tools → [API.md#call-tool](API.md), [EXAMPLES.md#call-a-simple-tool](EXAMPLES.md)
- Error handling → [EXAMPLES.md#error-handling](EXAMPLES.md)

**Troubleshooting:**
- Plugin not loading → [TROUBLESHOOTING.md#plugin-not-loading](TROUBLESHOOTING.md)
- Connection failed → [TROUBLESHOOTING.md#server-connection-failed](TROUBLESHOOTING.md)
- Tool not found → [TROUBLESHOOTING.md#tool-not-found](TROUBLESHOOTING.md)

**Development:**
- Architecture → [README.md#architecture](../README.md#architecture)
- API reference → [API.md](API.md)
- Contributing → [CONTRIBUTING.md](CONTRIBUTING.md)

## 🔗 External Resources

### Official Documentation
- [OpenClaw Documentation](https://docs.openclaw.ai)
- [MCP Specification](https://spec.modelcontextprotocol.io)
- [MCP TypeScript SDK](https://github.com/modelcontextprotocol/typescript-sdk)

### Community
- [OpenClaw Discord](https://discord.com/invite/openclaw)
- [GitHub Issues](https://github.com/yourorg/mcp-integration/issues)
- [GitHub Discussions](https://github.com/yourorg/mcp-integration/discussions)

## 📊 Documentation Versions

| Version | Date | Changes |
|---------|------|---------|
| 0.1.0 | 2026-02-01 | Initial documentation |

## ✅ Documentation Checklist

For new contributors or maintainers:

- [ ] README.md is up to date
- [ ] Configuration examples work
- [ ] API documentation matches code
- [ ] Examples are tested and working
- [ ] Troubleshooting covers common issues
- [ ] CHANGELOG is updated for new releases
- [ ] Links between documents work
- [ ] Code examples use correct syntax
- [ ] All claims are accurate

## 🆘 Getting Help

Can't find what you're looking for?

1. Use GitHub search across all docs
2. Check [TROUBLESHOOTING.md](TROUBLESHOOTING.md)
3. Ask in [Discord #plugins channel](https://discord.com/invite/openclaw)
4. [Open an issue](https://github.com/yourorg/mcp-integration/issues)

---

**Documentation maintained by:** Lob 🦞  
**Last updated:** 2026-02-01  
**Plugin version:** 0.1.0
