# Changelog

All notable changes to the MCP Integration plugin will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.1.0] - 2026-02-01

### Added
- Initial release of MCP Integration plugin
- HTTP/SSE transport implementation (`StreamableHTTPClientTransport`)
- Support for connecting to multiple MCP servers
- `mcp` tool with `list` and `call` actions
- Dynamic tool discovery from MCP servers
- Session management via `mcp-session-id` header
- Comprehensive documentation:
  - README.md - Main documentation
  - API.md - API reference
  - CONFIGURATION.md - Configuration guide
  - EXAMPLES.md - Usage examples
  - TROUBLESHOOTING.md - Troubleshooting guide
- Plugin metadata in `config/openclaw.plugin.json`
- JSON Schema validation for configuration

### Features
- ✅ HTTP/SSE transport for MCP protocol
- ✅ Multi-server support
- ✅ Automatic tool registration
- ✅ Error handling and logging
- ✅ Configurable timeouts and retries
- ✅ Session persistence across requests

### Technical Details
- Based on `@modelcontextprotocol/sdk` v0.5.0
- Implements MCP Streamable HTTP specification
- Compatible with OpenClaw 2026.1.0+
- Node.js 18.0.0+ required

## [Unreleased]

### Planned
- [ ] stdio transport support
- [ ] MCP Resources support
- [ ] MCP Prompts support
- [ ] Connection pooling
- [ ] Tool result caching
- [ ] Health check endpoints
- [ ] Metrics and monitoring
- [ ] Retry logic with exponential backoff
- [ ] Rate limiting
- [ ] Batch tool calls
- [ ] WebSocket transport

---

## Version History

| Version | Date | Description |
|---------|------|-------------|
| 0.1.0 | 2026-02-01 | Initial release with HTTP/SSE transport |

## Migration Guides

### Migrating to 0.1.0

First release - no migration needed.

## Breaking Changes

None yet - this is the initial release.

## Known Issues

- SSE stream is optional - some servers may not support GET requests
- Session persistence relies on server sending `mcp-session-id` header
- No automatic reconnection on connection loss
- No built-in rate limiting

## Support

For issues, questions, or feature requests:
- [GitHub Issues](https://github.com/yourorg/mcp-integration/issues)
- [Discord Community](https://discord.com/invite/openclaw)
- [Email Support](mailto:support@openclaw.ai)

---

**Maintained by:** Lob 🦞  
**License:** MIT
