# McKinsey Research - AI Strategy Consultant Skill

Turn any AI agent into a full McKinsey-level strategy consulting team for complete market research and analysis.

## What It Does

This skill runs a full suite of consulting-grade analyses on your business:

1. **Market Sizing & TAM Analysis** - Total addressable market with top-down and bottom-up approaches
2. **Competitive Landscape** - Top 10 competitors ranked by market share, revenue, and funding
3. **Customer Personas** - 4 detailed buyer personas with psychographics and buying behavior
4. **Industry Trends** - Macro and micro trends with 5-year timeline mapping
5. **SWOT + Porter's Five Forces** - Combined strategic analysis with cross-matching
6. **Pricing Strategy** - Competitor audit, value-based pricing, and 3-tier recommendations
7. **Go-To-Market Plan** - Launch phasing, channel strategy, and KPI framework
8. **Customer Journey Mapping** - Full lifecycle from awareness to advocacy
9. **Financial Modeling** - Unit economics, 3-year projections, and break-even analysis
10. **Risk Assessment** - 15 categorized risks with scenario planning
11. **Market Entry Strategy** - Expansion analysis with 12-month roadmap
12. **Executive Strategy Synthesis** - McKinsey-style strategic recommendation

## How It Works

1. The agent asks your preferred language (Arabic or English)
2. Collects all required business information in one structured intake
3. Runs all analyses sequentially with your data
4. Delivers each analysis as a complete consulting-grade deliverable

## Installation

### Universal (Works with all platforms)

```bash
npx skills add Abdullah4AI/mckinsey-research
```

### OpenClaw

```bash
clawhub install mckinsey-research
```

Or manually:

```bash
git clone https://github.com/Abdullah4AI/mckinsey-research.git
cp -r mckinsey-research ~/.openclaw/skills/
```

### Claude Code

```bash
git clone https://github.com/Abdullah4AI/mckinsey-research.git
cp -r mckinsey-research ~/.claude/skills/
```

### Antigravity

```bash
git clone https://github.com/Abdullah4AI/mckinsey-research.git
cp -r mckinsey-research agent/skills/
```

### Augment

```bash
git clone https://github.com/Abdullah4AI/mckinsey-research.git
cp -r mckinsey-research ~/.augment/skills/
```

### Cline

```bash
git clone https://github.com/Abdullah4AI/mckinsey-research.git
cp -r mckinsey-research cline/skills/
```

### CodeBuddy

```bash
git clone https://github.com/Abdullah4AI/mckinsey-research.git
cp -r mckinsey-research ~/.codebuddy/skills/
```

### Command Code

```bash
git clone https://github.com/Abdullah4AI/mckinsey-research.git
cp -r mckinsey-research ~/.commandcode/skills/
```

### Codex

```bash
git clone https://github.com/Abdullah4AI/mckinsey-research.git
cp -r mckinsey-research agent/skills/
```

## Usage

Just ask your AI agent for any of these:

- "Run a full market research for my business"
- "I need a competitive analysis for my product"
- "Do a McKinsey-style strategy analysis"
- "بحث سوق لمشروعي"
- "تحليل استراتيجي لمنتجي"

The skill triggers automatically and guides you through the process.

## File Structure

```
mckinsey-research/
├── SKILL.md              # Main skill instructions
├── references/
│   └── prompts.md        # The 12 strategy prompts with variables
└── README.md             # This file
```

## Credits

Built by [@Abdullah4AI](https://x.com/Abdullah4AI)

## License

MIT
