# Color Palette Quick Reference

| Name | Hex | RGB | Usage |
|------|-----|-----|-------|
| NAVY | #051C2C | (5, 28, 44) | Primary — titles, circles, TOC highlights |
| BLACK | #000000 | (0, 0, 0) | Separator lines, title underlines |
| WHITE | #FFFFFF | (255, 255, 255) | Backgrounds, text on navy |
| DARK_GRAY | #333333 | (51, 51, 51) | Body text |
| MED_GRAY | #666666 | (102, 102, 102) | Secondary text, labels, source notes |
| LINE_GRAY | #CCCCCC | (204, 204, 204) | Table row separators |
| BG_GRAY | #F2F2F2 | (242, 242, 242) | Background panels, takeaway areas |

## Python Constants

```python
NAVY      = RGBColor(0x05, 0x1C, 0x2C)
BLACK     = RGBColor(0x00, 0x00, 0x00)
WHITE     = RGBColor(0xFF, 0xFF, 0xFF)
DARK_GRAY = RGBColor(0x33, 0x33, 0x33)
MED_GRAY  = RGBColor(0x66, 0x66, 0x66)
LINE_GRAY = RGBColor(0xCC, 0xCC, 0xCC)
BG_GRAY   = RGBColor(0xF2, 0xF2, 0xF2)
```

## Font Size Hierarchy

| Size | Usage |
|------|-------|
| 44pt | Cover title only |
| 28pt | Section header |
| 22pt | Action title (bold, Georgia) |
| 18pt | Sub-header |
| 14pt | Body text (primary) |
| 9pt  | Footnote / source |
