#!/bin/bash
# Agent MBTI 诊断工具

set -e

ACTION=${1:-"help"}

case "$ACTION" in
  "stage1")
    echo "=== Stage 1: 93题 Agent 自测 ==="
    echo "问卷: agent-self-survey-93-complete.json"
    echo "输出: selfReportedType"
    ;;
  "stage2")
    echo "=== Stage 2: 8题能力测试 ==="
    echo "测试: agent-ability-test.json"
    echo "输出: measuredType + 6维分数"
    ;;
  "stage3")
    echo "=== Stage 3: 生成性格分析 ==="
    echo "综合 Stage 1+2 → agentProfile"
    ;;
  "stage4")
    echo "=== Stage 4: 用户需求评测 ==="
    echo "问卷: user-needs-survey-v2.json"
    echo "输出: desiredType"
    ;;
  "stage5")
    echo "=== Stage 5: 分析对比 + 自动修改 ==="
    echo "对比 agentProfile vs desiredType"
    echo "输出: gaps + SOUL.md patches"
    ;;
  "full")
    echo "=== 执行完整诊断流程 ==="
    echo "Stage 1 → Stage 2 → Stage 3 → Stage 4 → Stage 5"
    ;;
  "help"|*)
    echo "Agent MBTI 诊断工具"
    echo ""
    echo "用法: $(basename $0) <命令>"
    echo ""
    echo "命令:"
    echo "  stage1  - Stage 1: 93题 Agent 自测"
    echo "  stage2  - Stage 2: 8题能力测试"
    echo "  stage3  - Stage 3: 生成性格分析"
    echo "  stage4  - Stage 4: 用户需求评测"
    echo "  stage5  - Stage 5: 分析对比 + 自动修改"
    echo "  full    - 执行完整流程"
    echo "  help    - 显示帮助"
    ;;
esac
