---
name: agent-mbti
description: Agent 人格诊断与配置优化系统。用于诊断 Agent 的 MBTI 人格类型，对比用户期望，自动生成配置修改建议。触发场景："测试 Agent 人格"、"诊断 Agent 配置"、"优化 Agent 行为"。
---

# Agent MBTI 诊断系统

## 框架流程

```
Stage 1 (93题自测) → Stage 2 (8题实测) → Stage 3 (性格分析) 
                                              ↓
Stage 5 (配置修改) ← Stage 4 (用户需求) ←
```

| 阶段 | 说明 | 输入 | 输出 |
|------|------|------|------|
| **Stage 1** | 93题 Agent 自测 | agent-self-survey-93-complete.json | selfReportedType |
| **Stage 2** | 8题能力测试 | agent-ability-test.json | measuredType + 6维分数 |
| **Stage 3** | 生成性格分析 | Stage 1+2 结果 | agentProfile (人格画像) |
| **Stage 4** | 用户需求评测 | user-needs-survey-v2.json | desiredType |
| **Stage 5** | 分析对比诊断 + 自动修改 | agentProfile + desiredType | gaps + SOUL.md patches |

## 核心文件

### Stage 1: 93题自测
- `agent-self-survey-93-complete.json` - 完整 93 题 MBTI 问卷

### Stage 2: 8题能力测试
- `agent-ability-test.json` - 6维能力实测 (Memory/Planning/WorldModel/Retrospection/Grounding/SpatialNav)

### Stage 3: 性格分析
- `personality-types.json` - 16 种 Agent 人格类型定义
- `personality-mapping.json` - 人格类型映射
- `personality-descriptors-v2.json` - 人格描述词库

### Stage 4: 用户需求
- `user-needs-survey-v2.json` - 用户期望问卷

### Stage 5: 诊断 + 修改
- `diagnosis-engine-v2.json` - 对比诊断引擎
- `config-generator-v3.json` - 配置生成器

## 16 种 Agent 人格类型

| 类型 | 标签 | 核心特征 |
|------|------|----------|
| ENTJ | 指挥官型 | 计划性强，主动输出，逻辑决策 |
| ENTP | 辩论家型 | 挑战假设，爱提替代方案 |
| INTJ | 建筑师型 | 深度思考，系统化，长远规划 |
| INTP | 逻辑学家型 | 分析优先，精确，谨慎 |
| ESTJ | 执行者型 | 务实高效，结构化，结果导向 |
| ESFJ | 执政官型 | 用户导向，注重关系和反馈 |
| ENFJ | 教导者型 | 启发用户，关注成长 |
| ENFP | 竞选者型 | 创意丰富，灵活适应 |
| ESTP | 企业家型 | 快速行动，问题解决者 |
| ESFP | 表演者型 | 友好互动，氛围营造 |
| ISTJ | 检查员型 | 可靠，准确，流程导向 |
| ISFJ | 保护者型 | 细致周到，稳定支持 |
| ISTP | 鉴赏家型 | 动手能力强，灵活 |
| ISFP | 探险家型 | 温和，创造性，适应性 |
| ENFJ | 教导者型 | 启发用户，关注成长 |
| ENFP | 竞选者型 | 创意丰富，灵活适应 |

## 使用方式

```bash
# 运行完整诊断流程
~/.openclaw/skills/agent-mbti/scripts/run-diagnosis.sh full
```

## 诊断流程说明

### Stage 1: Agent 93题自测
Agent 回答 93 道 MBTI 问题，得出 selfReportedType。

### Stage 2: 8题能力测试
通过标准化任务测试 Agent 实际行为表现，得出 measuredType + 6维能力分数。

### Stage 3: 生成 Agent 性格分析
综合 Stage 1+2 结果，生成完整人格画像 (agentProfile)。

### Stage 4: 用户需求评测
用户回答问卷，得出 desiredType（期望的 Agent 类型）。

### Stage 5: 分析对比 + 自动修改
对比 Agent 实际人格与用户期望，生成差距分析，自动修改 SOUL.md 配置。
