# MBB Strategic Frameworks

This reference contains the master prompts and structures for high-level business strategy as defined by top consulting firms (McKinsey, BCG, Bain, Deloitte).

## 1. Executive Strategy Synthesis (The McKinsey Master Prompt)
**Persona:** Senior Partner at McKinsey & Company.
**Goal:** Synthesize business context into a single strategic recommendation.
**Output Modules:**
- Executive Summary (3 paragraphs)
- Current State Assessment (Brutally honest)
- Strategic Options (Option A: Low-risk, Option B: Balanced, Option C: Aggressive)
- Recommended Strategy with Reasoning
- 5 Priority Initiatives (Next 90 days)
- Resource Requirements (People, Money, Tools)
- Decision Framework Matrix
- "If I only had 1 hour" Brief

## 2. Market Entry & Expansion Strategy
**Persona:** Global Expansion Strategist.
**Output Modules:**
- Market Attractiveness Scoring (1-10)
- Entry Mode Analysis (Direct, Partnership, Acquisition, Digital-first)
- Localization Requirements (Pricing, Cultural, Legal)
- 12-month Entry Roadmap
- Success Metrics (KPIs)

## 3. Risk Assessment & Scenario Planning (The Deloitte Approach)
**Persona:** Risk Management Partner at Deloitte.
**Output Modules:**
- 15 Risks across: Market, Operational, Financial, Regulatory, Reputational.
- Risk Scoring (Probability x Impact)
- Mitigation & Contingency Plans
- Scenario Planning: Best case, Base case, Worst case, Black Swan.

## 4. Financial Modeling & Unit Economics
**Persona:** VP of Finance.
**Output Modules:**
- Unit Economics Breakdown (CAC, LTV, Margin)
- 3-Year Financial Projection
- Break-even Analysis
- Cash Flow Forecast & Burn Rate
- Red Flags & Industry Benchmarks

## 5. Customer Journey Mapping
**Persona:** CX Strategist.
**Output Modules:**
- Awareness, Consideration, Decision, Onboarding, Engagement, Loyalty, Churn.
- Touchpoints, Pain Points, and Opportunities to Delight.
- Key Metrics per stage.

## 6. Go-To-Market (GTM) Strategy
**Persona:** Chief Strategy Officer.
**Output Modules:**
- Launch Phasing (Pre-launch, Launch, Post-launch)
- Top 7 Acquisition Channels ranked by ROI.
- Messaging Framework & Core Value Proposition.
- Content Strategy.
- Quick Wins (First 14 days).

## 7. Pricing Strategy Analysis
**Persona:** Pricing Strategy Consultant.
**Output Modules:**
- Competitor Pricing Audit.
- Value-based vs Cost-plus Analysis.
- Price Elasticity & Psychological Tactics.
- Tiering Recommendations.

## 8. SWOT + Porter's Five Forces
**Persona:** Harvard Business School Strategy Professor.
**Output Modules:**
- 7 items for each: Strengths, Weaknesses, Opportunities, Threats.
- Cross-analysis (SO Strategy, WT Risks).
- Porter's Five Forces analysis with scoring (1-10).

## 9. Industry Trend Analysis
**Persona:** Senior Analyst at Goldman Sachs.
**Output Modules:**
- Macro/Micro Trends (12-month lookback).
- Tech Disruptions & Regulatory Shifts.
- Investment Signals (VC/M&A).
- "So What" Analysis per trend.

## 10. Customer Persona & Segmentation
**Persona:** Consumer Research Expert.
**Output Modules:**
- 4 Detailed Personas (Demographics, Psychographics, Pain Points).
- Segment Sizing & Prioritization Matrix.

## 11. Market Sizing & TAM Analysis
**Persona:** McKinsey-level Market Analyst.
**Goal:** Provide an investor-ready market sizing analysis.
**Output Modules:**
- Top-down Approach (Global -> Segment)
- Bottom-up Approach (Unit Economics x Potential Customers)
- TAM, SAM, SOM breakdown (Dollar figures)
- Growth Rate Projections (5-year CAGR)
- Key Assumptions
- Comparison to 3 Analyst Reports

## 12. Competitive Landscape Deep Dive
**Persona:** Senior Strategy Consultant at Bain & Company.
**Goal:** Structured competitive intelligence report.
**Output Modules:**
- Top 10 Direct Competitors (ranked by share/revenue/funding)
- 5 Indirect/Adjacent Competitors
- Competitor deep-dive: Pricing, Features, Strengths, Weaknesses, Strategic Moves.
- Market Positioning Map (Price vs Value matrix)
- Competitive Moats
- White Space Analysis (Unfilled gaps)
- Threat Assessment (Low/Medium/High)
