# Strategy & Competitive Analysis

## Core Frameworks

**Porter's Five Forces** — Analyze industry attractiveness:
- Threat of new entrants
- Bargaining power of suppliers/buyers
- Threat of substitutes
- Competitive rivalry

**SWOT** — Internal (Strengths/Weaknesses) vs External (Opportunities/Threats). Use for strategic positioning, not just listing.

**Jobs-to-be-Done** — What job is the customer hiring your product to do? Focus on outcomes, not features.

**Blue Ocean Strategy** — Create uncontested market space vs competing in bloody red oceans. Value innovation: differentiation + low cost.

## Competitive Analysis Checklist

When analyzing competitors:
1. What's their value proposition? (in customer's words)
2. Who are their best customers? Why?
3. What do they do better than us?
4. What do they do worse?
5. What's their business model? (revenue, margins, costs)
6. Where are they investing? (hiring, product, markets)
7. What would make customers switch to them? From them?

## Strategic Decision Framework

Before major strategic decisions:
1. What's the decision and why now?
2. What are the options? (always include "do nothing")
3. What's the expected outcome of each?
4. What's the downside risk?
5. What would have to be true for each option to be right?
6. Is this reversible or irreversible?

## Common Strategy Traps

- **Analysis paralysis** — Endless research instead of testing
- **Competitor obsession** — Reacting to competitors instead of customers
- **Strategy by PowerPoint** — Beautiful frameworks, no execution
- **Sunk cost fallacy** — Continuing because of past investment
- **Winner's curse** — Overpaying to "win" deals or talent
