# Entrepreneurship & Startups

## Fundraising

**Stages:**
- Pre-seed: Idea + early team, €50K-500K
- Seed: MVP + early traction, €500K-2M
- Series A: Product-market fit, €2M-15M
- Series B+: Scaling, €10M+

**What investors evaluate:**
1. Team — Can you execute?
2. Market — Is it big enough?
3. Traction — Is it working?
4. Product — Is it defensible?
5. Terms — Is the price right?

**Pitch deck structure:**
1. Problem (make them feel it)
2. Solution (clear and simple)
3. Market size (TAM/SAM/SOM)
4. Business model (how you make money)
5. Traction (metrics, growth)
6. Team (why you'll win)
7. Ask (amount, use of funds)

## Term Sheet Essentials

**Valuation:** Pre-money + Investment = Post-money

**Key terms to understand:**
- Liquidation preference: Who gets paid first
- Anti-dilution: Protection against down rounds
- Board composition: Who controls decisions
- Vesting: How equity is earned over time
- Pro-rata rights: Right to maintain ownership %

**Red flags:**
- Participating preferred (double-dip)
- Full ratchet anti-dilution
- Board control by investors
- Aggressive milestone-based tranches

## Unit Economics Deep Dive

**For any business:**
```
Revenue per unit
- Variable cost per unit
= Contribution margin

Contribution margin × Volume
- Fixed costs
= Operating profit
```

**Break-even:** Fixed costs / Contribution margin per unit

**Scaling question:** Does contribution margin stay positive as you grow?

## Product-Market Fit

**Signs you have it:**
- Organic growth (word of mouth)
- High retention
- Users would be "very disappointed" without it (>40% on Sean Ellis test)
- Demand exceeds supply

**Signs you don't:**
- Constant pivoting
- High churn
- Growth only through paid acquisition
- Users don't complain when it breaks

## Startup Prioritization

**ICE framework:**
- Impact: How much will it move the needle?
- Confidence: How sure are you?
- Ease: How fast/cheap to implement?

Score 1-10 each, multiply, prioritize by total.

**Weekly question:** What's the one thing that, if we nail it this week, makes everything else easier?
