# Operations & Metrics

## OKRs (Objectives and Key Results)

**Objective:** Qualitative, inspirational, time-bound
**Key Results:** Quantitative, measurable, verifiable

Example:
- Objective: Become the market leader in Spain
- KR1: Reach €1M ARR
- KR2: Achieve NPS > 50
- KR3: Grow team to 15 people

**Common traps:**
- Too many OKRs (max 3-5 objectives)
- Key Results that are tasks, not outcomes
- Setting easy OKRs to always "succeed"
- Not reviewing/adjusting quarterly

## Dashboard Design

**Principles:**
1. Few metrics that matter (5-7 max)
2. Leading indicators, not just lagging
3. Actionable — seeing it should prompt a decision
4. Updated frequently enough to act on

**Typical SaaS dashboard:**
- MRR and growth rate
- Active users / DAU/MAU
- Churn rate
- CAC and LTV
- Support tickets / response time
- NPS or satisfaction score

## Process Documentation

**When to document:**
- Task done repeatedly (>3 times)
- Task involves handoffs
- Task has compliance/legal requirements
- Onboarding new people

**How to document:**
- Start with outcome, not steps
- Include decision points (if X, then Y)
- Note who owns each step
- Include failure modes and fixes

## Bottleneck Analysis

**Theory of Constraints:**
1. Identify the constraint (slowest part)
2. Exploit it (maximize its output)
3. Subordinate everything else to it
4. Elevate it (invest to remove the constraint)
5. Repeat (new constraint will emerge)

**Questions:**
- Where do things pile up waiting?
- What's always behind schedule?
- What do people complain about most?
- If you could only fix one thing, what would have the biggest impact?

## Vendor/Partner Management

**Selection criteria:**
- Capability (can they do it?)
- Reliability (will they do it consistently?)
- Economics (at what cost?)
- Risk (what if they fail?)

**Contract essentials:**
- Clear deliverables and SLAs
- Exit clauses
- Pricing model and escalation
- Ownership of work product
