# Marketing & Growth

## The Marketing Funnel

Awareness → Interest → Consideration → Conversion → Retention → Referral

**Key principle:** Fix the bottom of the funnel first. No point driving traffic to a leaky bucket.

## Core Metrics

| Metric | Formula | Target |
|--------|---------|--------|
| CAC | Total acquisition spend / New customers | Lower is better |
| LTV | Avg revenue × Avg lifespan | > 3× CAC |
| Conversion Rate | Conversions / Visitors | Varies by stage |
| Churn Rate | Lost customers / Total customers | < 5% monthly |
| NPS | % Promoters - % Detractors | > 50 is excellent |

## Positioning

**Template:** For [target customer] who [need/pain], [product] is a [category] that [key benefit]. Unlike [alternatives], we [differentiator].

**Good positioning:**
- Specific target (not "everyone")
- Clear category (people need a mental box)
- Believable differentiation
- Matters to the customer (not just to you)

## Pricing Strategy

**Cost-plus:** Cost + margin. Simple but ignores value.

**Value-based:** Price based on customer value, not your costs.

**Competitive:** Match or undercut competitors.

**Questions before pricing:**
1. What's the customer's willingness to pay?
2. What's the cost to serve?
3. What do alternatives cost?
4. What pricing model fits usage patterns?
5. Can you test different prices?

## Channel Strategy

**Direct:** You control, higher margin, slower scale
**Indirect:** Partners/distributors, lower margin, faster scale
**Marketplace:** Platform takes cut, access to audience

**Channel fit:** Where do your customers already buy similar things?

## Common Marketing Traps

- **Build it and they will come** — Distribution is as hard as product
- **Features as benefits** — "We have AI" vs "Save 10 hours/week"
- **Targeting everyone** — Niche down first, expand later
- **Premature scaling** — Spending before product-market fit
- **Vanity metrics** — Followers, impressions vs actual conversions
