# Leadership & Management

## Hiring

**Before hiring:**
1. What outcomes do you need? (not just tasks)
2. What skills are required vs trainable?
3. What's the profile of someone who succeeds here?

**Interview structure:**
- Past behavior predicts future behavior
- Ask "Tell me about a time when..." not hypotheticals
- Check references — actually call them
- Trial projects > interview performance

**Common traps:**
- Hiring for skills, ignoring culture fit
- Hiring fast, firing slow (should be opposite)
- Cloning yourself instead of complementing gaps

## Feedback

**Framework:** Situation → Behavior → Impact → Request

Example: "In the meeting today (situation), you interrupted Maria twice (behavior). It made her hesitant to share ideas (impact). Next time, let others finish before responding (request)."

**Regular cadence:**
- Weekly 1:1s: Check progress, remove blockers
- Monthly: Performance trends, development
- Quarterly: Goals review, career conversations

## Difficult Conversations

**Preparation:**
1. What's the core message? (one sentence)
2. What facts support it?
3. What outcome do you want?
4. What might they say? How will you respond?

**During:**
- Be direct. Softening too much causes confusion.
- Listen. Ask for their perspective.
- Focus on behavior and impact, not personality.
- End with clear next steps.

## Team Scaling Stages

| Team Size | Focus |
|-----------|-------|
| 1-5 | Everyone does everything, hire generalists |
| 5-15 | Specialization begins, need processes |
| 15-50 | Managers required, communication overhead |
| 50+ | Org structure critical, culture codification |

## Delegation Framework

**What to delegate:**
- Tasks others can do 80% as well
- Tasks that develop your team
- Tasks outside your highest-value work

**How to delegate:**
1. Clear outcome and constraints
2. Right level of context
3. Check understanding
4. Agree on check-ins
5. Let them own it (don't micromanage)

## Meeting Hygiene

- Every meeting needs an owner and agenda
- Default to 25 or 50 minutes, not 30 or 60
- End with decisions and action items
- If no decision needed, could it be an email?
