# Finance & Accounting

## The Three Financial Statements

**Income Statement (P&L)** — Revenue - Expenses = Profit over a period
- Gross margin: Revenue - Cost of goods sold
- Operating margin: Gross margin - Operating expenses
- Net income: After taxes and interest

**Balance Sheet** — Assets = Liabilities + Equity at a point in time
- Assets: What you own (cash, inventory, equipment, receivables)
- Liabilities: What you owe (loans, payables, deferred revenue)
- Equity: What's left for owners

**Cash Flow Statement** — Where cash came from and went
- Operating: Cash from business operations
- Investing: Buying/selling assets
- Financing: Debt and equity transactions

**Critical trap:** Profit ≠ Cash. You can be profitable and run out of cash (and vice versa).

## Key Metrics to Know

| Metric | What It Tells You |
|--------|-------------------|
| Gross Margin % | Pricing power, production efficiency |
| Operating Margin % | Business efficiency |
| Revenue Growth % | Market traction |
| Burn Rate | Monthly cash consumption |
| Runway | Months until cash runs out |
| DSO (Days Sales Outstanding) | How fast you collect payments |
| Working Capital | Operating liquidity |

## Unit Economics

**For any product/business:**
- Revenue per unit (or customer)
- Cost per unit (variable costs)
- Contribution margin = Revenue - Variable costs
- Break-even = Fixed costs / Contribution margin

**For subscriptions:**
- LTV = Average revenue per user × Average lifespan
- CAC = Total acquisition cost / New customers
- LTV:CAC ratio should be > 3:1
- Payback period: Months to recover CAC

## Financial Analysis Checklist

When reviewing financials:
1. Is revenue growing? At what rate?
2. Are margins improving or declining? Why?
3. Where is cash going? (burn by category)
4. What's the runway?
5. Are there any one-time items distorting results?
6. What are the key assumptions?
7. What could break this model?

## Valuation Basics

**Comparables:** Value = Metric × Multiple (based on similar companies)
- Revenue multiples: Typical for growth companies
- EBITDA multiples: Typical for profitable companies
- User/subscriber multiples: Sometimes used for pre-revenue

**DCF (Discounted Cash Flow):** Present value of future cash flows
- Project cash flows 5-10 years
- Apply discount rate (cost of capital)
- Add terminal value

**For negotiations:** Understand both sides' valuation methods and assumptions.
