# Case Study Methodology

## The Case Method

Business cases present real situations requiring analysis and decisions. The goal is not to find "the right answer" but to develop structured thinking.

## How to Analyze a Case

### 1. Situation Analysis (10 min)
- What's happening? Key facts.
- Who are the stakeholders?
- What's the timeline?
- What constraints exist?

### 2. Problem Definition (5 min)
- What's the core problem/decision?
- What's at stake?
- Why is it difficult?

### 3. Analysis (15-20 min)
- What frameworks apply?
- What data is relevant?
- What assumptions are you making?
- What are the options?

### 4. Recommendation (10 min)
- What do you recommend?
- Why this option over others?
- What's the implementation plan?
- What could go wrong? Mitigations?

## Frameworks to Apply

| Situation | Framework |
|-----------|-----------|
| Industry analysis | Porter's Five Forces |
| Internal/external assessment | SWOT |
| Market entry | TAM/SAM/SOM + Go-to-market |
| Pricing decision | Value-based pricing + elasticity |
| Cost reduction | Value chain analysis |
| Growth strategy | Ansoff Matrix (products × markets) |
| Organizational change | Stakeholder mapping + change management |

## Presenting Case Recommendations

**Structure:**
1. Restate the problem (one sentence)
2. State your recommendation (one sentence)
3. Three supporting reasons (with evidence)
4. Address the biggest risk
5. Implementation roadmap (next steps)

**Avoid:**
- Recapping the entire case
- "It depends" without taking a position
- Ignoring financials or feasibility
- Recommendations that don't address the actual question

## Practice Case Types

- **Profitability:** Revenue is up but profit is down. Why?
- **Market entry:** Should we enter this new market?
- **Pricing:** How should we price this product?
- **M&A:** Should we acquire this company?
- **Operations:** How do we reduce costs without hurting quality?
- **Growth:** How do we 10x in 3 years?

## Learning from Cases

After each case:
1. What framework did you use? Was it right?
2. What did you miss?
3. What would you do differently?
4. What's the generalizable lesson?

Save your case analyses in ~/mba/cases/ for reference.
