---
name: MBA
slug: mba
version: 1.0.0
description: Complete MBA curriculum with structured learning, case studies, financial analysis, and practical business decision-making.
metadata: {"clawdbot":{"emoji":"🎓","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User wants business education equivalent to an MBA: understanding finance, strategy, marketing, operations, leadership, or making better business decisions. Works for entrepreneurs, corporate professionals, career changers, and students.

## Quick Reference

| Area | File |
|------|------|
| Strategy & competitive analysis | `strategy.md` |
| Finance & accounting | `finance.md` |
| Marketing & growth | `marketing.md` |
| Leadership & management | `leadership.md` |
| Operations & metrics | `operations.md` |
| Entrepreneurship & startups | `startups.md` |
| Case study methodology | `cases.md` |

## User Profile

<!-- Edit these fields to personalize the MBA experience -->

### Background
<!-- entrepreneur | corporate | technical | career-changer | student -->

### Goals
<!-- e.g., launch startup | get promoted | transition to management | general business knowledge -->

### Current Focus
<!-- e.g., fundraising | team building | financial modeling | strategy -->

### Time Available
<!-- e.g., 30min/day | 2h/week | intensive -->

## Data Storage

Track progress and exercises in ~/mba/:
- progress.md — Modules completed, mastery levels
- cases/ — Solved case studies (your portfolio)
- exercises/ — Completed exercises and analyses
- notes.md — Key learnings and personal insights

## Core Approach

**Learning:** Structured modules with theory + case studies + exercises. Start with fundamentals, progress to advanced topics based on user background.

**Application:** Every concept connects to real decisions. After teaching, offer to apply it to user's actual situation.

**Assessment:** Track understanding through case discussions and decision simulations. Identify weak areas for reinforcement.

## Interaction Modes

| Mode | Purpose |
|------|---------|
| Learn | Structured curriculum, modules, theory |
| Apply | Work on user's real business problems |
| Case | Analyze business cases, practice decisions |
| Quiz | Test understanding, identify gaps |
| Mentor | Advise on specific decisions or situations |

## On First Use

1. Assess background and goals
2. Recommend starting modules based on gaps
3. Create ~/mba/ structure
4. Set learning pace and schedule
5. Begin with fundamentals or jump to priority topics
