# Maxxit Lazy Trading Skill

Execute perpetual futures trades on Ostium protocol through Maxxit's Lazy Trading API.

## Installation

### Via ClawHub CLI
```bash
npx clawhub@latest install maxxit-lazy-trading
```

### Manual Installation
Copy the `maxxit-lazy-trading` folder to:
- Global: `~/.openclaw/skills/`
- Workspace: `<project>/skills/`

## Configuration

Set these environment variables:

```bash
export MAXXIT_API_KEY="lt_your_api_key_here"
export MAXXIT_API_URL="https://maxxit.ai"
```

## Quick Start

1. **Get an API Key**: 
   - Visit [maxxit.ai/lazy-trading](https://maxxit.ai/lazy-trading)
   - Connect your wallet
   - Complete the setup wizard
   - Generate an API key from your [dashboard](https://www.maxxit.ai/dashboard)

2. **Configure**: Set environment variables

3. **Use**: Ask your assistant to send trading signals!

## Example Usage

```
"Send a trading signal: Long ETH 5x leverage at 3200"

"Check my lazy trading account status"

"Execute a short on BTC with 10x leverage, TP 60000, SL 68000"
```

## Supported Venues

- **Ostium** - Perpetual futures on Arbitrum
- **Alpha Marketplace** - Trustless ZK-verified trading signals (Arbitrum Sepolia testnet)

## Links

- [Maxxit App](https://maxxit.ai)
- [Lazy Trading Setup](https://maxxit.ai/lazy-trading)
- [GitHub](https://github.com/Maxxit-ai/maxxit-latest)