---
name: master-marketing
description: All-in-one marketing engine combining growth strategy, content remixing, and trend monitoring. Drive growth with data-driven strategies, repurposed content across all platforms, and real-time trend analysis.
metadata:
  openclaw:
    emoji: "🚀"
    version: "1.0.0"
    author: "Sencer"
    tags: ["marketing", "growth", "content", "trends", "seo", "social-media", "strategy"]
    requires:
      bins: []
      env: []
      config: []
---

# Master Marketing

## Description

Master Marketing is the ultimate all-in-one marketing engine for AI agents. It combines **Growth Strategy**, **Content Remixing**, and **Trend Monitoring** into a single powerful skill that drives organic growth through data-driven strategies, intelligent content repurposing, and real-time trend analysis.

Stop juggling multiple tools. Master Marketing handles everything from funnel analysis to viral content creation to trend-based campaign planning.

---

## What This Skill Combines

### 🎯 Growth Strategy (from Growth Skill)
- North Star Metric definition and tracking
- AARRR funnel analysis (Acquisition → Activation → Retention → Referral → Revenue)
- Growth loop identification and optimization
- Experiment framework (ICE scoring)
- Retention analysis with cohort tracking

### 🎬 Content Remixing (from Content Remix Studio)
- Single source → multi-platform transformation
- YouTube, TikTok, Instagram, LinkedIn, Twitter, Blog, Newsletter optimization
- Platform-specific hook psychology
- Content atomization strategies
- Cross-promotion planning

### 📈 Trend Monitoring (from Trend Watcher)
- Real-time trend detection
- Industry-specific trend analysis
- Trend opportunity scoring
- Seasonal and event-based planning
- Competitive trend positioning

---

## Core Capabilities

### 1. Growth Analysis

#### North Star Metric
Define and track your most important metric:
- **Define**: What single metric reflects customer value?
- **Track**: Daily/weekly/monthly tracking
- **Optimize**: Find the path to improvement

#### AARRR Funnel Analysis
Measure each stage of the customer journey:

| Stage | What to Measure | Typical Actions |
|-------|-----------------|-----------------|
| **Acquisition** | Traffic sources, CAC, conversion rate | SEO, paid, social, referrals |
| **Activation** | Signups, onboarding completion | Free trials, demos, first value moment |
| **Retention** | DAU/MAU, return rate, churn | Email sequences, content, features |
| **Referral** | Viral coefficient, NPS | Referral programs, testimonials |
| **Revenue** | ARPU, LTV, conversion rate | Pricing optimization, upsells |

#### Growth Loops

Identify and optimize your growth loops:

**Viral Loop**: User → invites friends → friends become users
- Measure: viral coefficient (invites × conversion)
- Optimize: sharing incentives, friction reduction

**Content Loop**: Content → SEO/social → users → more content
- Measure: content ROI, traffic per piece
- Optimize: content quality, distribution

**Paid Loop**: Revenue → reinvest → users → revenue
- Measure: CAC payback period, ROAS
- Optimize: targeting, creative, landing pages

**Sales Loop**: Sales → customers → case studies → leads
- Measure: pipeline velocity, referral rate
- Optimize: sales enablement, case studies

### 2. Content Strategy

#### Multi-Platform Transformation

Transform one piece of content into platform-optimized versions:

| Platform | Format | Length | Key Element |
|----------|--------|--------|--------------|
| **YouTube** | Long-form video | 8-15 min | Timestamps, hook, CTA |
| **TikTok/Reels** | Short video | 15-60 sec | 3-sec hook, loop |
| **Instagram** | Carousel/Reels | 6-10 slides | Save-worthy |
| **LinkedIn** | Article/Post | 1,300-2,000 chars | Professional hook |
| **Twitter** | Thread | 8-15 tweets | Numbered format |
| **Blog** | SEO article | 1,500-2,500 words | Keyword-rich |
| **Newsletter** | Email | Personal tone | Single CTA |

#### Platform-Specific Optimization

**YouTube Strategy:**
- Front-load keywords in title (60-70 chars)
- Compelling description with timestamps
- High-contrast thumbnail
- Ask for engagement at 30% mark

**TikTok/Reels Strategy:**
- Hook in first 1-3 seconds
- Text overlays (large, bold)
- Trending sound integration
- Loop-ability for algorithm

**LinkedIn Strategy:**
- First line hook (make them click "see more")
- Professional tone with personal stories
- 3-5 relevant hashtags
- Engagement prompt at end

**Twitter Strategy:**
- Thread structure with numbered tweets
- Engagement bait (questions, polls)
- Quote-tweetable moments
- Post timing: 8-10 AM or 5-7 PM

**Instagram Strategy:**
- Carousel storytelling (problem → solution)
- High-contrast design
- Save/share prompts
- Story highlights tie-in

#### Content Atomization

Take one piece and create 20+ micro-content pieces:

**From 1 YouTube Video:**
- 10 TikTok clips
- 5 Instagram Reels
- 3 Twitter threads
- 2 LinkedIn posts
- 1 blog post
- 10 quote graphics
- 1 newsletter

### 3. Trend Intelligence

#### Trend Detection

Monitor and identify relevant trends:

**Sources to Monitor:**
- Google Trends
- Twitter/X trending topics
- LinkedIn industry feeds
- Reddit communities
- Product Hunt
- TechCrunch / VentureBeat
- Industry newsletters
- Competitor content

#### Trend Scoring

Evaluate trends by opportunity:

| Factor | Score (1-10) |
|--------|--------------|
| **Relevance** | How relevant to your audience? |
| **Timing** | Early, peak, or declining? |
| **Competition** | Few or many creators? |
| **Longevity** | Flash or evergreen? |
| **Alignment** | Fits brand voice? |

#### Trend-Based Campaign Planning

Create campaigns around trending topics:

1. **Detect**: Find trending topic in your niche
2. **Score**: Evaluate opportunity
3. **Create**: Develop content angle
4. **Execute**: Rapid deployment
5. **Measure**: Track performance

---

## Usage Examples

### Example 1: Growth Strategy + Content Remix

**User**: "Our SaaS startup needs a complete marketing overhaul. We're losing users after signup and want to grow 3x in 6 months."

**Assistant Response**:

**Phase 1: Growth Audit**
```
🔍 North Star Metric: Weekly Active Users (WAU)

📊 AARRR Analysis:
- Acquisition: Good (CAC $50, industry avg $80)
- Activation: PROBLEM (only 23% complete onboarding)
- Retention: WARNING (40% churn in week 1)
- Referral: Weak (0.8 viral coefficient)
- Revenue: Stable (3% conversion, $99 ARPU)

🎯 Priority: Fix activation first (leaky bucket)
```

**Phase 2: Content Strategy**
```
📝 Content Pillar: "Productivity for Remote Teams"

🎬 Multi-Platform Distribution:
- YouTube: 15-min deep dive
- TikTok: 5 clips (30-60 sec each)
- LinkedIn: 3-part series
- Twitter: 2 threads
- Instagram: 10 carousel slides
- Blog: 2,000-word SEO article
- Newsletter: Weekly productivity tips
```

**Phase 3: Trend Integration**
```
📈 Trending Topics to Leverage:
1. "Remote work burnout" - High relevance
2. "AI productivity tools" - High opportunity
3. "Hybrid work policies" - Growing interest

Campaign: "5 AI Tools That Actually Boost Remote Productivity"
```

---

### Example 2: Content Remix + Trend Monitoring

**User**: "We just published a blog post about 'The Future of AI in Education.' How do we maximize its reach?"

**Assistant Response**:

**Content Remix Plan:**

| Platform | Content Type | Hook |
|----------|-------------|------|
| YouTube | Video summary | "AI is Revolutionizing Education - Here's Proof" |
| TikTok | 3 clips | "POV: Your teacher just used AI" |
| LinkedIn | Article series | "3 Ways AI Changes Education Forever" |
| Twitter | Thread | "I analyzed 100 education AI tools. Here's what I found 🧵" |
| Instagram | Carousel | "AI in Education - By the Numbers" |
| Newsletter | Email | "The Future is Here: AI in Classrooms" |

**Trend Integration:**
```
📈 Current Trends to Leverage:
- "AI in classrooms" - Trending up 200%
- "ChatGPT for students" - Peak search interest
- "EdTech investment" - News cycle opportunity

Suggested Angle: "Beyond the Hype: What Actually Works in AI Education"
```

**Publishing Schedule:**
| Day | Platform | Content |
|-----|----------|---------|
| Monday | LinkedIn | Part 1 - The Change |
| Tuesday | TikTok | Clip 1 - The Hook |
| Wednesday | YouTube | Full Video |
| Thursday | Twitter | Thread |
| Friday | Instagram | Carousel |
| Weekend | Newsletter | Synthesis |

---

### Example 3: Trend-Based Campaign

**User**: "A major industry trend just emerged. How do we create a campaign around it in 48 hours?"

**Assistant Response**:

**Rapid Response Framework:**

**Hour 0-4: Planning**
```
🎯 Trend: [Industry Trend Name]
📊 Trend Score: 8/10 (High opportunity)
💰 Estimated Reach: 500K+ impressions
⏰ Decay: ~72 hours until saturation
```

**Hour 4-24: Creation**
```
Content Assets:
1. Main pillar content (YouTube/video)
2. Supporting blog post (SEO)
3. 3 TikTok/Reels clips
4. LinkedIn article
5. Twitter thread
6. Instagram carousel
7. Email to list
```

**Hour 24-48: Distribution**
```
🚀 Launch Sequence:
Hour 24: Twitter thread (fastest reach)
Hour 26: TikTok clips (viral potential)
Hour 28: LinkedIn article (professional)
Hour 32: YouTube video (deep dive)
Hour 36: Instagram carousel (visual)
Hour 40: Newsletter (owned audience)
Hour 48: Repurpose top performers
```

---

## Strategic Frameworks

### The Growth-Content-Trinity

| Component | Purpose | Output |
|-----------|---------|--------|
| **Growth** | Strategy & metrics | Funnel optimization, experiments |
| **Content** | Distribution & reach | Multi-platform assets |
| **Trends** | Timing & relevance | Campaign ideas, angles |

### The 1-10-100 Content Rule

| Investment | Output |
|------------|--------|
| 1 hour | Pillar content creation |
| 10 minutes × 10 pieces | Micro-content remixing |
| 100 hours | Audience value delivered |

### The Trend Opportunity Matrix

| Trend Type | Speed | Investment | Expected ROI |
|------------|-------|------------|--------------|
| **Viral trend** | 24-48 hours | Low | High (if fast) |
| **Growing trend** | 1-2 weeks | Medium | High |
| **Established** | Ongoing | Low | Stable |
| **Declining** | Skip | - | - |

---

## When to Use This Skill

Use Master Marketing when you need:

### Growth & Strategy
- Defining or revising North Star Metric
- Analyzing AARRR funnel performance
- Identifying growth bottlenecks
- Planning experiments
- Optimizing retention

### Content Strategy
- Repurposing content across platforms
- Creating platform-specific content
- Planning content calendar
- Optimizing for algorithms
- Maximizing content ROI

### Trend Intelligence
- Monitoring industry trends
- Creating trend-based campaigns
- Finding content angles
- Timing content release
- Competitive positioning

---

## Common Workflows

### Workflow 1: Weekly Marketing Planning

1. **Review** - Check last week's metrics
2. **Analyze** - Identify trends to leverage
3. **Plan** - Schedule content for the week
4. **Create** - Remix content from pillars
5. **Execute** - Deploy across platforms
6. **Measure** - Track and iterate

### Workflow 2: New Product Launch

1. **Pre-launch (2-4 weeks)**
   - Create pillar content
   - Build email list
   - Tease on social media

2. **Launch Week**
   - Multi-platform content blast
   - Trend leverage
   - Paid amplification

3. **Post-launch (2-4 weeks)**
   - Repurpose top performers
   - Test and iterate
   - Build on momentum

### Workflow 3: Competitor Response

1. **Detect** - Competitor launches campaign
2. **Analyze** - What's working for them?
3. **Differentiate** - Find your angle
4. **Execute** - Rapid response campaign
5. **Convert** - Turn attention to your brand

---

## Output Examples

### Growth Analysis Report

```markdown
# Growth Analysis Report

## North Star Metric: [Metric]
Current: [Value] | Target: [Value] | Gap: [Diff]

## Funnel Performance

| Stage | Rate | Industry Avg | Gap |
|-------|------|--------------|-----|
| Acquisition | 5.2% | 4.8% | +0.4% |
| Activation | 23% | 45% | -22% ⚠️ |
| Retention | 60% | 65% | -5% |
| Referral | 0.8 | 1.2 | -0.4 |
| Revenue | 3% | 4% | -1% |

## Top Growth Opportunities
1. [Fix onboarding - high impact, medium effort]
2. [Add referral incentives - medium impact, low effort]
3. [Optimize landing pages - medium impact, medium effort]

## Recommended Experiments
1. [Experiment 1] - ICE Score: 8.5
2. [Experiment 2] - ICE Score: 7.2
```

### Content Remix Plan

```markdown
# Content Remix Plan

## Source: [Original Content]
Type: [Blog/Video/Podcast]
Topic: [Topic]

## Multi-Platform Distribution

### YouTube
- Title: [Optimized title]
- Description: [With timestamps]
- Thumbnail concept: [Description]

### TikTok/Reels (3 clips)
Clip 1: [Hook] - [Main point 1]
Clip 2: [Hook] - [Main point 2]
Clip 3: [Hook] - [Main point 3]

### LinkedIn
- Post: [Professional angle]
- CTA: [Engagement prompt]

### Twitter (Thread)
Tweet 1: [Hook with promise]
Tweets 2-8: [Value delivery]
Tweet 9: [Summary]
Tweet 10: [CTA]

### Instagram
Carousel (10 slides):
- Slide 1: Hook + promise
- Slides 2-8: Main content
- Slide 9: Results/data
- Slide 10: CTA

## Publishing Schedule
| Platform | Day | Time |
|----------|-----|------|
| Twitter | Monday | 9 AM |
| LinkedIn | Tuesday | 8 AM |
| YouTube | Thursday | 2 PM |
```

### Trend Alert Report

```markdown
# Trend Alert

## Trend: [Trend Name]
Category: [Industry/Topic]
Trend Score: 8/10

## Metrics
- Search volume: [XXX]
- Growth rate: [+XX% week-over-week]
- Sentiment: [Positive/Neutral/Negative]

## Opportunity
- Relevance: [High/Medium/Low]
- Competition: [Low/Medium/High]
- Longevity: [Flash/Short/Medium/Long]

## Recommended Action
[Go Fast / Monitor / Skip]

## Content Angles
1. [Angle 1]
2. [Angle 2]
3. [Angle 3]

## Example Content
[Quick content mockup]
```

---

## Integration with Other Skills

| Skill | Integration Point |
|-------|-------------------|
| **CMO** | Strategic alignment, budget planning |
| **SEO/Search** | Keyword research, content optimization |
| **Social Media** | Platform posting, engagement |
| **Email Marketing** | Newsletter content, drip campaigns |
| **Analytics** | Performance tracking, reporting |

---

## Important Notes

- **Quality over quantity**: One great piece beats ten mediocre ones
- **Test and iterate**: Platforms and audiences change constantly
- **Own your audience**: Email lists beat algorithm dependency
- **Measure what matters**: Focus on revenue-impacting metrics
- **Stay adaptable**: What works today may not work tomorrow

---

*Master Marketing: Grow smarter, content louder, trends faster.*


## 🚀 Gelişen Uygulama Dersleri
_Son Güncelleme: 2026-02-12 09:25_

### 🔄 Güncellenen Framework'ler

| Framework | Güncelleme | Tarih |
|-----------|------------|-------|

